%define realname DirectFB

Name: directfb
Version: 1.1.0
Release: alt7

Summary: %realname - drivers and binaries
License: LGPLv2.1
Group: System/Libraries

Url: http://www.directfb.org
Source: %realname-%version.tar.gz

Patch0:	%realname-am.patch
Patch1:	%realname-pmake.patch
Patch2:	%realname-fix.patch

# http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=462626&msg=35
Patch3:	%realname-tty.patch

# http://bugs.gentoo.org/show_bug.cgi?id=200661
Patch4:	%realname-0.9.25.1-sysfs.patch

Patch5: %realname-alt-libadd-fix.patch
# http://mail.directfb.org/pipermail/directfb-dev/2011-February/006048.html
# http://mail.directfb.org/pipermail/directfb-dev/2011-February/006049.html
Patch6: directfb-1.1.0-libpng15.patch
Patch7: directfb-1.1.0-nocruft.patch

# Automatically added by buildreq on Sun Dec 14 2008
BuildRequires: gcc-c++ glibc-devel-static libX11-devel libXext-devel libfreetype-devel libjpeg-devel libpng-devel libsysfs-devel man

%description
%realname is a graphics library which was designed with embedded systems
in mind. It offers maximum hardware accelerated performance at a minimum
of resource usage and overhead.

%package -n lib%name
Summary: %realname - graphics and windowing library on Linux framebuffer
Group: System/Libraries

%description -n lib%name
%realname is a graphics library which was designed with embedded systems
in mind. It offers maximum hardware accelerated performance at a minimum
of resource usage and overhead.

%package -n lib%name-devel
Summary: Includes and other files for devel %realname applications
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel

%description -n lib%name-devel
Devel for %realname is a graphics library which was designed with embedded systems
in mind. It offers maximum hardware accelerated performance at a minimum
of resource usage and overhead.

%prep
%setup -n %realname-%version
%patch0 -p1 -b .fix0
%patch1 -p1 -b .fix1
%patch2 -p1 -b .fix2
%patch3 -p1 -b .fix3
%patch4 -p1 -b .fix4
%patch5 -p1 -b .fix5
%patch6 -p1
%patch7 -p2

%build
export DRIVERS=all
%ifarch %e2k
export DRIVERS=radeon
%endif
%autoreconf
%configure \
	--enable-fbdev \
	--enable-shared \
	--disable-static \
	--with-pic \
	--with-gfxdrivers=$DRIVERS \
	#
%make_build

%install
%makeinstall_std

find %buildroot -name \*.la -delete
{
	find %buildroot%_libdir/%name-* -name '*.so' -print
	find %buildroot%_libdir/%name-* -type d -printf '%%%%dir %%p\n'
} |
	sed -e 's#%{buildroot}##' |
	sort -u > %name.files

%files -f %name.files
%doc TODO fb.modes
%_bindir/mk*
%_bindir/dfb*
%_datadir/%name-*
%_man1dir/dfb*
%_man5dir/*

%files -n lib%name
%doc AUTHORS NEWS README
%_libdir/lib*.so.*

%files -n lib%name-devel
%_includedir/*
%_bindir/%{name}*
%_libdir/lib*.so
%_pkgconfigdir/*.pc
%_man1dir/%{name}*

%changelog
