# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1

Name: dm-secdel
Version: 1.0.11
Release: alt2

Summary: dm-linear with secure deletion on discard
License: GPL-2.0-only
Group: System/Kernel and hardware
Requires: /sbin/dmsetup /sbin/blockdev /usr/bin/expr
BuildArch: noarch

Url: https://github.com/vt-alt/dm-secdel
Source: %name-%version.tar

BuildRequires(pre): rpm-build-kernel
%{?!_without_check:%{?!_disable_check:
BuildRequires: figlet
BuildRequires: rpm-build-vm
%if 0%{?kernel_latest:1}
BuildRequires: kernel-headers-modules-latest
%else
BuildRequires: kernel-headers-modules-std-def
BuildRequires: kernel-headers-modules-un-def
%endif
%if 0%{?kernel_new:1}
BuildRequires: kernel-new
BuildRequires: kernel-headers-modules-new
%endif
}}

%description
Linear device-mapper target with secure deletion on discard.

%package -n kernel-source-%name
Summary: dm-linear with secure deletion on discard (source)
Group: Development/Kernel
BuildArch: noarch

%description -n kernel-source-%name
Linear device-mapper target with secure deletion on discard (source).

%prep
%setup

%install
make install-bin DESTDIR=%buildroot UNITDIR=%_unitdir
install -pDm0644 %_sourcedir/%name-%version.tar %kernel_srcdir/kernel-source-%name-%version.tar
mkdir %buildroot/etc
echo '# <target name> <source device> <options>' > %buildroot/etc/secdeltab

%check
./check.sh

%files -n kernel-source-%name
%kernel_src/kernel-source-%name-%version.tar

%files
%doc README.md
%config /etc/secdeltab
/sbin/secdelsetup
%_unitdir/secdeltab.service

%post
%post_service secdeltab
systemctl -q enable secdeltab

%preun
%preun_service secdeltab

%changelog
