# subpackages build order
# - bootstrap
# - ordering
# - configurator
# - dyn
# - stdune
# - private-libs
# - site
# - xdg
# - dune-build-info
# - ocamlc-loc
# - chrome-trace
# - dune-rpc

%define dune_pkg dyn
%if "%dune_pkg" != "bootstrap"
%define subpackagename -%dune_pkg
%def_with subpackage
%def_without check
%else
%define subpackagename %nil
%def_without subpackage
%def_with check
%endif

Name: dune%subpackagename
Version: 3.17.1
Release: alt2
Summary: A composable build system for OCaml
Group: Development/ML
License: MIT
Url: https://github.com/ocaml/dune
Source0: dune-%version.tar
Patch0: dune-%version-%release.patch
Provides: ocaml-dune = %EVR

BuildRequires: ocaml >= 4.14.0
BuildRequires: rpm-build-ocaml >= 1.5
%if_with subpackage
BuildRequires: dune
BuildRequires: ocaml-csexp-devel
%endif

%if "%dune_pkg" == "bootstrap"
%package -n emacs-dune
Summary: Emacs support for Ocaml Dune
Requires: %name = %EVR
Requires: emacs-common
BuildRequires: rpm-build-emacs
BuildArch: noarch
Group: Development/ML
%description -n emacs-dune
The %{name}-emacs package contains Emacs integration with the dune build
system, a mode to edit dune files, and flymake support for dune files.
%endif

%description
Dune is a build system designed for OCaml/Reason projects only. It focuses
on providing the user with a consistent experience and takes care of most of
the low-level details of OCaml compilation. All you have to do is provide a
description of your project and Dune will do the rest.

The scheme it implements is inspired from the one used inside Jane Street and
adapted to the open source world. It has matured over a long time and is used
daily by hundred of developers, which means that it is highly tested and
productive.

%if "%dune_pkg" == "configurator"
%define pkgname %name
%package -n ocaml-%name
Group: Development/ML
Summary: Helper dune library for gathering system configuration
Requires: ocaml-result-devel
Requires: dune = %EVR
%description -n ocaml-%name
dune-configurator is a small library that helps writing OCaml scripts that
test features available on the system, in order to generate config.h
files for instance.
Among other things, dune-configurator allows one to:
- test if a C program compiles
- query pkg-config
- import #define from OCaml header files
- generate config.h file
%endif

%if "%dune_pkg" == "private-libs"
%define pkgname %name
%package -n ocaml-%name
Group: Development/ML
Summary: Runtime files for %name
Requires: dune = %EVR
BuildRequires: ocaml-dyn-devel = %version
BuildRequires: ocaml-stdune-devel = %version
%description -n ocaml-%name
This package contains code that is shared between various dune-xxx
packages. However, it is not meant for public consumption and provides
no stability guarantee.
%endif

%if "%dune_pkg" == "site"
%define pkgname %name
%package -n ocaml-%name
Group: Development/ML
Summary: Embed location information inside executables and libraries
Requires: dune = %EVR
BuildRequires: ocaml-dune-private-libs-devel = %version
BuildRequires: ocaml-compiler-libs >= 5.2.0
%description -n ocaml-%name
This library enables embedding location information inside executables
and libraries.
%endif

%if "%dune_pkg" == "ordering"
%define pkgname %dune_pkg
%package -n ocaml-%dune_pkg
Group: Development/ML
Summary: Element ordering
Requires: dune = %EVR
%description -n ocaml-%dune_pkg
Element ordering
%endif

%if "%dune_pkg" == "dyn"
%define pkgname %dune_pkg
%package -n ocaml-%dune_pkg
Group: Development/ML
Summary: Dynamic type
Requires: dune = %EVR
BuildRequires: ocaml-ordering-devel = %version ocaml-pp-devel
%description -n ocaml-%dune_pkg
Dynamic type.
%endif

%if "%dune_pkg" == "stdune"
%define pkgname %dune_pkg
%package -n ocaml-%pkgname
Group: Development/ML
Summary: Dune's unstable standard library
Requires: dune = %EVR
BuildRequires: ocaml-ordering-devel = %version
BuildRequires: ocaml-csexp-devel ocaml-pp-devel ocaml-dyn-devel = %version
%description -n ocaml-%pkgname
This library offers no backwards compatibility guarantees. Use at your own risk.
%endif

%if "%dune_pkg" == "xdg"
%define pkgname %dune_pkg
%package -n ocaml-%pkgname
Group: Development/ML
Summary: XDG Base Directory Specification
Requires: dune = %EVR
BuildRequires: dune = %version
%description -n ocaml-%pkgname
XDG Base Directory Specification
%endif

%if "%dune_pkg" == "dune-build-info"
%define pkgname %dune_pkg
%package -n ocaml-%pkgname
Group: Development/ML
Summary: Embed build information inside executable
Requires: dune = %EVR
BuildRequires: dune = %version
%description -n ocaml-%pkgname
The build-info library allows to access information about how the executable
was built, such as the version of the project at which it was built or the
list of statically linked libraries with their versions.
It supports reporting the version from the version control system during
development to get an precise reference of when the executable was built.
%endif

%if "%dune_pkg" == "ocamlc-loc"
%define pkgname %dune_pkg
%package -n ocaml-%pkgname
Group: Development/ML
Summary: Parse ocaml compiler output into structured form
Requires: dune = %EVR
BuildRequires: dune = %version
BuildRequires: ocaml-dyn-devel = %version
%description -n ocaml-%pkgname
%summary

This library offers no backwards compatibility guarantees. Use at your own risk.
%endif

%if "%dune_pkg" == "chrome-trace"
%define pkgname %dune_pkg
%package -n ocaml-%pkgname
Group: Development/ML
Summary: Chrome trace event generation library
Requires: dune = %EVR
BuildRequires: dune = %version
BuildRequires: ocaml-dyn-devel = %version
%description -n ocaml-%pkgname
%summary

This library offers no backwards compatibility guarantees. Use at your own risk.
%endif

%if "%dune_pkg" == "dune-rpc"
%define pkgname %dune_pkg
%package -n ocaml-%pkgname
Group: Development/ML
Summary: Communicate with dune using rpc
Requires: dune = %EVR
BuildRequires: dune = %version
BuildRequires: ocaml-dyn-devel = %version
BuildRequires: ocaml-csexp-devel
BuildRequires: ocaml-ordering-devel
BuildRequires: ocaml-stdune-devel >= %version
BuildRequires: ocaml-pp-devel
BuildRequires: ocaml-xdg-devel
BuildRequires: ocaml-odoc-devel
%description -n ocaml-%pkgname
Library to connect and control a running dune instance.

%endif

%if_with subpackage
%package -n ocaml-%pkgname-devel
Summary: Development files for %name
Group: Development/ML
Requires: ocaml-result-devel
Requires: ocaml-%pkgname = %EVR
%description -n ocaml-%pkgname-devel
The ocaml-%pkgname-devel package contains libraries and signature files for
developing applications that use ocaml-%pkgname.
%endif

%prep
%setup -n dune-%version
%patch0 -p1

%build
sed -i '/^(name/a (version %version)' dune-project
./configure --libdir=%_libdir/ocaml \
	    --mandir=%_mandir  \
	    --datadir=%_datadir \
	    --etcdir %_sysconfdir \
	    --bindir %_bindir \
            --sbindir %_sbindir \
	    --docdir %_docdir \
	    %nil

%if_without subpackage
%make_build release
%else
rm -rf vendor/csexp vendor/pp
%dune_build -p %pkgname
%endif

%install
%if_with subpackage
%dune_install %pkgname
%else
./dune.exe install --destdir=%buildroot dune
%byte_recompile_lispdir
%endif

%check
./dune.exe runtest test/unit-tests --release

%if_without subpackage
%files
%doc README.md CHANGES.md
%_ocamldir/dune/META
%_ocamldir/dune/dune-package
%_ocamldir/dune/opam
%_bindir/dune
%_man1dir/dune.1*
%_man1dir/dune-describe.1*
%_man1dir/dune-help.1*
%_man1dir/dune-printenv.1*
%_man1dir/dune-promote.1*
%_man1dir/dune-build.1*
%_man1dir/dune-cache.1*
%_man1dir/dune-clean.1*
%_man1dir/dune-exec.1*
%_man1dir/dune-external-lib-deps.1*
%_man1dir/dune-install.1*
%_man1dir/dune-init.1*
%_man1dir/dune-installed-libraries.1*
%_man1dir/dune-ocaml-merlin.1*
%_man1dir/dune-rules.1*
%_man1dir/dune-runtest.1*
%_man1dir/dune-subst.1*
%_man1dir/dune-test.1*
%_man1dir/dune-top.1*
%_man1dir/dune-uninstall.1*
%_man1dir/dune-utop.1*
%_man5dir/dune-config.5*
%_man1dir/dune-format-dune-file.1.*
%_man1dir/dune-upgrade.1.*
%_man1dir/dune-coq.1.*
%_man1dir/dune-diagnostics.1.*
%_man1dir/dune-fmt.1.*
%_man1dir/dune-internal.1.*
%_man1dir/dune-monitor.1.*
%_man1dir/dune-ocaml.1.*
%_man1dir/dune-pkg.1.*
%_man1dir/dune-package.1.*
%_man1dir/dune-rpc.1.*
%_man1dir/dune-show.1.*
%_man1dir/dune-shutdown.1.*
%_man1dir/dune-tools.1.*
%_man1dir/dune-promotion.1.*

%files -n emacs-dune
%_emacslispdir/*
%endif

%if_with subpackage
%files -n ocaml-%pkgname -f ocaml-files.runtime

%files -n ocaml-%pkgname-devel -f ocaml-files.devel
%endif

%changelog
