%global optflags_lto %nil
%define tool_chain_tag GCC5

# More subpackages to come once licensing issues are fixed
Name: edk2-aarch64
Version: 20250221
Release: alt1
Summary: AARCH64 Virtual Machine Firmware

License: BSD-2-Clause-Patent
Group: Emulators
Url: http://www.tianocore.org

#Vcs-Git: https://github.com/tianocore/edk2.git
Source: %name-%version.tar
#Vcs-Git: https://github.com/openssl/openssl
Source2: openssl.tar
#Vcs-Git: https://github.com/ucb-bar/berkeley-softfloat-3.git
Source3: berkeley-softfloat-3.tar
#Vcs-Git: https://github.com/devicetree-org/pylibfdt.git
Source4: libfdt.tar
Source9: Logo.bmp

# json description files
Source10: 50-edk2-aarch64-qcow2.json
Source11: 51-edk2-aarch64-raw.json
Source12: 52-edk2-aarch64-verbose-qcow2.json
Source13: 53-edk2-aarch64-verbose-raw.json

Patch1: %name-%version.patch

ExclusiveArch: aarch64 loongarch64 x86_64
BuildArch: noarch

Provides: edk2-ovmf-aarch64 = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: iasl nasm gcc-c++
BuildRequires: python3-devel python3-modules-sqlite3
BuildRequires: libuuid-devel
BuildRequires: qemu-img
BuildRequires: bc
# openssl configure
BuildRequires: /usr/bin/pod2man bc zlib-devel perl-PathTools perl-IPC-Cmd perl-JSON
%if %_build_cpu != aarch64
BuildRequires: gcc-aarch64-linux-gnu
%define gcc_triplet aarch64-linux-gnu-
%else
%define gcc_triplet %nil
%endif

Requires: ipxe-roms-qemu

%description
EFI Development Kit II
AARCH64 UEFI Firmware

%prep
%setup -q
%patch1 -p1

cp -f %SOURCE9 MdeModulePkg/Logo/

# cleanup
find . -name '*.efi' -print0 | xargs -0 rm -f
rm -rf \
        UefiCpuPkg/ResetVector/Vtf0/Bin/*.raw \
        EdkCompatibilityPkg/Other \
        AppPkg \
        DuetPkg/BootSector/bin \
        StdLib/LibC/Main/Ia32/ftol2.obj \
        BeagleBoardPkg/Debugger_scripts/rvi_dummy.axf \
        BaseTools/Source/Python/*/*.pyd \
        BaseTools/Source/Python/UPT/Dll/sqlite3.dll \
        Vlv2TbltDevicePkg/GenBiosId \
        Vlv2TbltDevicePkg/*.exe \
        BaseTools/Bin/GccLto/liblto-*.a

# Ensure old shell and binary packages are not used
rm -rf EdkShellBinPkg
rm -rf EdkShellPkg
rm -rf FatBinPkg
rm -rf ShellBinPkg

# add openssl
mkdir -p CryptoPkg/Library/OpensslLib/openssl
tar -xf %SOURCE2 --strip-components 1 --directory CryptoPkg/Library/OpensslLib/openssl

# add berkeley-softfloat-3
mkdir -p ArmPkg/Library/ArmSoftFloatLib/berkeley-softfloat-3
tar -xf %SOURCE3 --strip-components 1 --directory ArmPkg/Library/ArmSoftFloatLib/berkeley-softfloat-3

# add libfdt
mkdir -p MdePkg/Library/BaseFdtLib/libfdt
tar -xf %SOURCE4 --strip-components 1 --directory MdePkg/Library/BaseFdtLib/libfdt

# include paths pointing to unused submodules
mkdir -p MdePkg/Library/MipiSysTLib/mipisyst/library/include
mkdir -p CryptoPkg/Library/MbedTlsLib/mbedtls/include
mkdir -p CryptoPkg/Library/MbedTlsLib/mbedtls/include/mbedtls
mkdir -p CryptoPkg/Library/MbedTlsLib/mbedtls/library
mkdir -p SecurityPkg/DeviceSecurity/SpdmLib/libspdm/include

%build
export PYTHON_COMMAND=%__python3
export EXTRA_OPTFLAGS="%optflags"
%if %_build_cpu != aarch64
export GCC_AARCH64_PREFIX=aarch64-linux-gnu-
export GCC5_AARCH64_PREFIX=aarch64-linux-gnu-
%endif
python3 CryptoPkg/Library/OpensslLib/configure.py

# for mkdosfs
export PATH=/sbin:$PATH

source ./edksetup.sh

# compiler
CC_FLAGS="-t %tool_chain_tag"

# common features
#CC_FLAGS="${CC_FLAGS} --cmd-len=65536 -b DEBUG --hash"
#CC_FLAGS="${CC_FLAGS} -b DEBUG --hash"
CC_FLAGS="${CC_FLAGS} -b RELEASE"
CC_FLAGS="${CC_FLAGS} --cmd-len=65536"
CC_FLAGS="${CC_FLAGS} -D NETWORK_IP6_ENABLE=TRUE"
CC_FLAGS="${CC_FLAGS} -D NETWORK_TLS_ENABLE=TRUE"
CC_FLAGS="${CC_FLAGS} -D NETWORK_HTTP_BOOT_ENABLE=TRUE"
CC_FLAGS="${CC_FLAGS} -D NETWORK_ISCSI_ENABLE=TRUE"
CC_FLAGS="${CC_FLAGS} -D NETWORK_ALLOW_HTTP_CONNECTIONS=TRUE"
CC_FLAGS="${CC_FLAGS} -D TPM1_ENABLE=FALSE"
CC_FLAGS="${CC_FLAGS} -D CAVIUM_ERRATUM_27456=TRUE"

VERBOSE_FLAGS="-D DEBUG_PRINT_ERROR_LEVEL=0x8040004F"
SILENT_FLAGS="-D DEBUG_PRINT_ERROR_LEVEL=0x80000000"
TPM_FLAGS="-D TPM2_ENABLE=TRUE -DTPM2_CONFIG_ENABLE=TRUE"
NO_TPM_FLAGS="-D TPM2_ENABLE=FALSE"

PCD_RELEASE_DATE=$(date -d %version "+%%m/%%d/%%Y")
PCD_VENDOR="--pcd PcdFirmwareVendor=ALTLinux"
PCD_VERSION="--pcd PcdFirmwareVersionString=%version"
PCD_DATE="--pcd PcdFirmwareReleaseDateString=${PCD_RELEASE_DATE}"
PCD_NX_COMPAT="--pcd PcdDxeNxMemoryProtectionPolicy=0xC000000000007FD1 --pcd PcdUninstallMemAttrProtocol=TRUE"
PCD_FLAGS="${PCD_VENDOR} ${PCD_VERSION} ${PCD_DATE} ${PCD_NX_COMPAT}"

# arm firmware features
#ARM_FLAGS="-t %%tool_chain_tag -b DEBUG --cmd-len=65536"
ARM_FLAGS="${CC_FLAGS}"


unset MAKEFLAGS

# prepare
#cp /usr/share/seabios/bios-csm.bin OvmfPkg/Csm/Csm16/Csm16.bin
#cp /usr/share/seabios/bios-csm.bin corebootPkg/Csm/Csm16/Csm16.bin
%make_build \
        -C BaseTools

#(cd UefiCpuPkg/ResetVector/Vtf0; python Build.py)

# build aarch64 firmware
mkdir -p AAVMF
%{gcc_triplet}gcc -c -fpic BaseTools/Bin/GccLto/liblto-aarch64.s -o BaseTools/Bin/GccLto/liblto-aarch64.a

# Build with a verbose debug mask first, and stash the binary.
build ${ARM_FLAGS} ${VERBOSE_FLAGS} ${TPM_FLAGS} ${PCD_FLAGS} -n 1 -a AARCH64 -p ArmVirtPkg/ArmVirtQemu.dsc
cp -a Build/ArmVirtQemu-AARCH64/*/FV/QEMU_EFI.fd AAVMF/QEMU_EFI.verbose.fd
cp -a Build/ArmVirtQemu-AARCH64/*/FV/QEMU_EFI.fd AAVMF/QEMU_EFI-pflash.raw
cp -a Build/ArmVirtQemu-AARCH64/*/FV/QEMU_VARS.fd AAVMF/QEMU_VARS.fd
cp -a Build/ArmVirtQemu-AARCH64/*/FV/QEMU_VARS.fd AAVMF/vars-template-pflash.raw
truncate --size 64m AAVMF/QEMU_EFI-pflash.raw
truncate --size 64m AAVMF/vars-template-pflash.raw

# Build with a silent (errors only) debug mask.
build ${ARM_FLAGS} ${SILENT_FLAGS} ${TPM_FLAGS} ${PCD_FLAGS} -n 1 -a AARCH64 -p ArmVirtPkg/ArmVirtQemu.dsc
cp -a Build/ArmVirtQemu-AARCH64/*/FV/QEMU_EFI.fd AAVMF/QEMU_EFI.silent.fd
cp -a Build/ArmVirtQemu-AARCH64/*/FV/QEMU_EFI.fd AAVMF/QEMU_EFI-silent-pflash.raw
truncate --size 64m AAVMF/QEMU_EFI-silent-pflash.raw

# Build with a silent (errors only) debug mask and without TPM
build ${ARM_FLAGS} ${SILENT_FLAGS} ${NO_TPM_FLAGS} ${PCD_FLAGS} -n 1 -a AARCH64 -p ArmVirtPkg/ArmVirtQemu.dsc
cp -a Build/ArmVirtQemu-AARCH64/*/FV/QEMU_EFI.fd AAVMF/QEMU_EFI.kernel.fd

for raw in AAVMF/*.raw; do
    qcow2="${raw%%.raw}.qcow2"
    qemu-img convert -f raw -O qcow2 -o cluster_size=4096 -S 4096 "$raw" "$qcow2"
done

%install
# For distro-provided firmware packages, the specification
# (https://git.qemu.org/?p=qemu.git;a=blob;f=docs/interop/firmware.json)
# says the JSON "descriptor files" to be searched in this directory:
# `/usr/share/firmware/`.  Create it.

mkdir -p %buildroot%_datadir/qemu/firmware
mkdir -p %buildroot%_datadir/{edk2,AAVMF}

cp -a AAVMF %buildroot%_datadir/
ln -r -s %buildroot%_datadir/AAVMF %buildroot%_datadir/edk2/aarch64
ln -r -s %buildroot%_datadir/AAVMF/QEMU_EFI-silent-pflash.raw %buildroot%_datadir/AAVMF/AAVMF_CODE.fd
ln -r -s %buildroot%_datadir/AAVMF/vars-template-pflash.raw %buildroot%_datadir/AAVMF/AAVMF_VARS.fd

for f in %_sourcedir/*edk2-aarch64*.json; do
    install -pm 644 $f %buildroot%_datadir/qemu/firmware
done

%files
%_datadir/AAVMF
%_datadir/edk2/aarch64
%_datadir/qemu/firmware/*edk2-aarch64*.json

%changelog
