%define _unpackaged_files_terminate_build 1
%define _user _eggdrop
%define _group _eggdrop
%define _home %_localstatedir/%name

Name: eggdrop
Version: 1.9.5
Release: alt1

Summary: Eggdrop is an IRC bot, written in C
License: GPL-2.0
Group: Networking/IRC

Url: http://www.eggheads.org
Packager: Vladimir V Kamarzin <vvk@altlinux.ru>

Source0: %name-%version.tar
Source1: %name.README.ALT.UTF8
Source2: %name.init
Source3: %name.tmpfiles
Patch1: %name-fix-config-interpreter.patch
Patch2: %name-pathes.patch

BuildRequires: tcl-devel zlib-devel autoconf
BuildRequires: libssl-devel
%add_findreq_skiplist %_datadir/%name/scripts/*

%description
Eggdrop is an IRC bot, written in C.  If you don't know what IRC is,
this is probably not whatever you're looking for!  Eggdrop, being a
bot, sits on a channel and takes protective measures: to keep the
channel from being taken over (in the few ways that anything CAN),
to recognize banished users or sites and reject them, to recognize
privileged users and let them gain ops, etc.

%prep
%setup
%patch1 -p2
%patch2 -p1

%build
%autoreconf
%configure
make config
%make_build

%install
install -dm1770 %buildroot/run/%name
install -dm1770 %buildroot%_logdir/%name

mkdir -p %buildroot%_libdir/%name/
mkdir -p %buildroot%_datadir/%name
mkdir -p %buildroot%_docdir/%name-%version/
mkdir -p %buildroot%_man1dir/
mkdir -p %buildroot%_logdir/%name

%make DEST=%buildroot%_datadir/%name install

# Move modules into /usr/lib*
mkdir -p %buildroot%_libdir
mv -f %buildroot%_datadir/%name/modules* %buildroot%_libdir/%name

# move binaries
mkdir -p %buildroot%_bindir
mv -f %buildroot%_datadir/%name/{%name,%name-%version} %buildroot%_bindir

# initscript
install -pDm0755 %SOURCE2 %buildroot%_initdir/%name

# manpage
install -m644 doc/man1/%name.1 %buildroot%_man1dir
rm -rf doc/man1

# Fix paths of example eggdrop.conf
sed -i  -e "s,scripts/,%_datadir/%name/scripts/,g" \
	-e "s,help/,%_datadir/%name/help/,g" \
	-e "s,modules/,%_libdir/%name/modules/,g" \
	-e "s,language/,%_datadir/%name/language/,g" \
	-e "s,text/,%_datadir/%name/text/,g" %name.conf
install -pDm0755 eggdrop.conf %buildroot%_sysconfdir/%name.conf
mkdir -p %buildroot%_home
ln -s ../../../etc/eggdrop.conf %buildroot%_home/eggdrop.conf

# README.ALT
install -pDm0644 %SOURCE1 README.ALT.UTF8

# scripts directory
install -dm1770 %buildroot%_home/scripts

# remove unnedded stuff
rm -rf %buildroot%_datadir/%name/doc

# install tmpfiles
install -Dpm644 %SOURCE3 %buildroot%_tmpfilesdir/%name.conf

%pre
/usr/sbin/groupadd -r -f %_group ||:
/usr/sbin/useradd -g %_group -c 'The eggdrop' \
        -d %_home -s /dev/null -r %_user >/dev/null 2>&1 ||:

%files
%doc doc/* README*
%dir %_libdir/%name
%dir %_datadir/%name/language
%dir %_libdir/%name/modules-%version
%dir %_datadir/%name/help
%dir %_datadir/%name/help/set
%dir %_datadir/%name/help/msg
%dir %_datadir/%name/scripts
%dir %_datadir/%name/text
%dir %attr(1770,root,%_group) %_home
%dir %attr(1770,root,%_group) %_home/scripts
%dir %attr(1770,root,%_group) /run/%name
%dir %attr(1770,root,%_group) %_logdir/%name
%config(noreplace) %_sysconfdir/%name.conf
%_initdir/%name
%_bindir/%name
%_bindir/%name-%version
%_libdir/%name/modules
%_libdir/%name/modules-%version/*.so
%_datadir/%name/*
%_home/eggdrop.conf
%_tmpfilesdir/%name.conf
%_man1dir/%name.1.*

%changelog
