%def_disable snapshot

%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_prefix/libexec

%define ver_major 3.56
%define ver_base 3.56
%define ver_lib 1.2
%define ver_libecal 2.0
%define sover_libecal 3
%define ver_serverui4 1.0

%def_disable debug
%def_disable static
%def_with libdb
%def_with openldap
%def_without static_ldap
%def_with krb5
%def_enable goa
%def_enable gtk3
%def_enable gtk4
%def_enable google
%def_enable oauth2_webkitgtk3
%def_disable oauth2_webkitgtk4
%def_enable canberra
%def_enable phonenumber
# Ubuntu online accounts support
%def_disable uoa
%{?_enable_snapshot:%def_enable gtk_doc}
%def_disable gtk_doc
%def_enable introspection
%def_enable vala
%def_enable installed_tests

Name: evolution-data-server
Version: %ver_major.2
Release: alt1

Summary: Evolution Data Server
License: LGPL-2.1
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Evolution

Vcs: https://gitlab.gnome.org/GNOME/evolution-data-server.git

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif
Patch1: %name-1.4.2.1-debug-lock.patch

%add_findprov_lib_path %_libdir/%name

%define glib_ver 2.68.0
%define gtk3_ver 3.20.0
%define gtk4_ver 4.6.6
%define soup3_ver 3.1.1
%define secret_ver 0.5
%define sqlite_ver 3.7.17
%define gweather4_ver 4.1.0
%define ical_ver 3.0.7
%define goa_ver 3.8.0
%define vala_ver 0.13.1
%define webkit_api_ver 4.1
%define webkit_ver 2.36.5

Requires: dconf

BuildRequires(pre): rpm-macros-cmake rpm-build-xdg rpm-build-gir
BuildRequires: cmake gcc-c++ ninja-build

BuildRequires: gnome-common
BuildRequires: glib2-devel >= %glib_ver
%{?_enable_gtk3:BuildRequires: libgtk+3-devel >= %gtk3_ver}
%{?_enable_gtk4:BuildRequires: libgtk4-devel >= %gtk4_ver}
BuildRequires: libxml2-devel
BuildRequires: pkgconfig(libsoup-3.0) >= %soup3_ver
BuildRequires: libsqlite3-devel >= %sqlite_ver
BuildRequires: libgweather4.0-devel >= %gweather4_ver
BuildRequires: libical-glib-devel >= %ical_ver
BuildRequires: libsecret-devel >= %secret_ver
BuildRequires: gperf docbook-utils flex bison libcom_err-devel libnss-devel libnspr-devel zlib-devel libicu-devel
BuildRequires: pkgconfig(uuid)
%{?_enable_goa:BuildRequires: libgnome-online-accounts-devel >= %goa_ver liboauth-devel}
%{?_enable_oauth2_webkitgtk3:BuildRequires: pkgconfig(webkit2gtk-%webkit_api_ver) >= %webkit_ver}
%{?_enable_oauth2_webkitgtk4:BuildRequires: pkgconfig(webkit2gtk-6.0) >= %webkit_ver}
BuildRequires: libjson-glib-devel
%{?_enable_uoa:BuildRequires: libaccounts-glib-devel}
%{?_enable_introspection:
BuildRequires: gobject-introspection-devel gir(Soup) = 3.0 gir(Json) = 1.0
%{?_enable_gtk3:BuildRequires: libgtk+3-gir-devel}
%{?_enable_gtk4:BuildRequires: libgtk4-gir-devel}
BuildRequires: libical-glib-gir-devel}
%{?_with_libdb:BuildRequires: libdb4-devel}
%{?_with_krb5:BuildRequires: libkrb5-devel}
%{?_enable_vala:BuildRequires: vala >= %vala_ver vala-tools >= %vala_ver}
%{?_enable_canberra:BuildRequires: libcanberra-gtk3-devel}
%{?_enable_phonenumber:BuildRequires: libphonenumber-devel}
%{?_enable_gtk_doc:BuildRequires: gtk-doc gi-docgen}

# /usr/libexec/evolution-data-server/csv2vcard uses perl(diagnostics.pm)
BuildRequires: perl(diagnostics.pm)

%if_with openldap
BuildRequires: libldap-devel
%if_with static_ldap
BuildRequires: libldap-devel-static libssl-devel libsasl2-devel
%endif
%endif

%description
Evolution Data Server provides a central location for
addressbook and calendar in the GNOME Desktop.

%package devel
Summary: Development files for Evolution Data Server
Group: Development/C
Requires: %name = %EVR

%description devel
This package provides development files for Evolution Data Server

%package devel-doc
Summary: Development documentation for Evolution Data Server
Group: Development/Documentation
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
Evolution Data Server provides a central location for
addressbook and calendar in the GNOME Desktop.

This package contains development documentation for Evolution Data Server.

%package gir
Summary: GObject introspection data for the EDS
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Evolution Data Server libraries

%package gir-devel
Summary: GObject introspection devel data for the EDS
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the Evolution Data Server libraries

%package vala
Summary: Vala language bindings for the EDS libraries
Group: Development/Other
BuildArch: noarch
Requires: %name = %EVR

%description vala
This package provides Vala language bindings for the EDS libraries

%package tests
Summary: Tests for the EDS
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed EDS libraries.


%prep
%setup
%if_enabled debug
%patch1 -p1
%endif

%build
%add_optflags %(getconf LFS_CFLAGS)
# reenable RPATH* to link against private libraries
%cmake \
	-GNinja \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
	-DCMAKE_SKIP_RPATH:BOOL=OFF \
	-DCAMEL_LOCK_HELPER_GROUP:STRING=mail \
	-DSENDMAIL_PATH:STRING=%_sbindir/sendmail \
	-DENABLE_FILE_LOCKING:STRING=fcntl \
	-DENABLE_DOT_LOCKING:BOOL=OFF \
	-DENABLE_SCHEMAS_COMPILE:BOOL=OFF \
	-DENABLE_SMIME:BOOL=ON \
	%{?_disable_gtk3:-DENABLE_GTK=OFF} \
	%{?_with_libdb:-DWITH_LIBDB:BOOL=ON} \
	%{?_with_openldap:-DWITH_OPENLDAP:BOOL=ON} \
	%{?_with_static_ldap:-DWITH_STATIC_LDAP:BOOL=ON} \
	%{?_with_krb5:-DWITH_KRB5:BOOL=ON} \
	%{?_enable_goa:-DENABLE_GOA:BOOL=ON} \
	%{?_disable_google:-DENABLE_GOOGLE_AUTH:BOOL=OFF} \
	%{?_disable_oauth2_webkitgtk3:-DENABLE_OAUTH2_WEBKITGTK=OFF} \
	%{?_disable_oauth2_webkitgtk4:-DENABLE_OAUTH2_WEBKITGTK4=OFF} \
	%{?_disable_canberra:-DENABLE_CANBERRA:BOOL=OFF} \
	%{?_enable_phonenumber:-DWITH_PHONENUMBER=%_libdir} \
	%{?_disable_uoa:-DENABLE_UOA:BOOL=OFF} \
	%{?_enable_introspection:-DENABLE_INTROSPECTION:BOOL=ON} \
	%{?_enable_gtk_doc:-DENABLE_GTK_DOC:BOOL=ON} \
	%{?_enable_vala:-DENABLE_VALA_BINDINGS:BOOL=ON} \
	%{?_enable_installed_tests:-DENABLE_INSTALLED_TESTS:BOOL=ON}
%nil
%cmake_build

%install
%cmake_install
# if unstable
ln -s camel-lock-helper-%ver_lib %buildroot%_libexecdir/camel-lock-helper

%find_lang --with-gnome --output=%name.lang %name %name-%ver_base

%files -f %name.lang
%_xdgconfigdir/autostart/org.gnome.Evolution-alarm-notify.desktop
%_desktopdir/org.gnome.Evolution-alarm-notify.desktop
%_desktopdir/org.gnome.evolution-data-server.OAuth2-handler.desktop
%_libexecdir/*
%{?_enable_installed_tests:%exclude %_libexecdir/%name/installed-tests/}
%dir %_libdir/%name/addressbook-backends
%dir %_libdir/%name/calendar-backends
%dir %_libdir/%name/camel-providers
%_libdir/%name/*/*.so
%_libdir/%name/*/*.urls
%_libdir/*.so.*
%_libdir/%name/libedbus-private.so
%_datadir/%name/
%_datadir/dbus-1/services/*
%_prefix/lib/systemd/user/evolution-addressbook-factory.service
%_prefix/lib/systemd/user/evolution-calendar-factory.service
%_prefix/lib/systemd/user/evolution-source-registry.service
%_prefix/lib/systemd/user/evolution-user-prompter.service

%_datadir/pixmaps/*
%_iconsdir/hicolor/scalable/apps/org.gnome.Evolution-alarm-notify.svg
%_datadir/GConf/gsettings/evolution-data-server.convert
%_datadir/glib-2.0/schemas/org.gnome.evolution-data-server.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.Evolution.DefaultSources.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution-data-server.addressbook.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution-data-server.calendar.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.eds-shell.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.evolution.shell.network-config.gschema.xml
%doc AUTHORS NEWS README MAINTAINERS

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled gtk_doc
%files devel-doc
%_gtk_docdir/*
%endif

%if_enabled introspection
%files gir
%_typelibdir/Camel-%ver_lib.typelib
%_typelibdir/EBookContacts-%ver_lib.typelib
%_typelibdir/EDataServer-%ver_lib.typelib
%{?_enable_gtk3:%_typelibdir/EDataServerUI-%ver_lib.typelib}
%{?_enable_gtk4:%_typelibdir/EDataServerUI4-%ver_serverui4.typelib}
%_typelibdir/EBook-%ver_lib.typelib
%_typelibdir/EBackend-%ver_lib.typelib
%_typelibdir/ECal-%ver_libecal.typelib
%_typelibdir/EDataBook-%ver_lib.typelib
%_typelibdir/EDataCal-%ver_libecal.typelib

%files gir-devel
%_girdir/Camel-%ver_lib.gir
%_girdir/EBookContacts-%ver_lib.gir
%_girdir/EDataServer-%ver_lib.gir
%{?_enable_gtk3:%_girdir/EDataServerUI-%ver_lib.gir}
%{?_enable_gtk4:%_girdir/EDataServerUI4-%ver_serverui4.gir}
%_girdir/EBook-%ver_lib.gir
%_girdir/EBackend-%ver_lib.gir
%_girdir/ECal-%ver_libecal.gir
%_girdir/EDataBook-%ver_lib.gir
%_girdir/EDataCal-%ver_libecal.gir
%endif

%if_enabled vala
%files vala
%_datadir/vala/vapi/*.deps
%_datadir/vala/vapi/*.vapi
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/%name/installed-tests/
%_datadir/installed-tests/%name/
%endif

%changelog
