%def_enable shared
%def_disable static

%define fsname f2fs
Name: %fsname-tools
Version: 1.16.0
Release: alt1

Summary: Tools for Flash-Friendly File System (F2FS)

License: GPLv2
Group: System/Kernel and hardware
URL: http://sourceforge.net/projects/f2fs-tools
# https://git.kernel.org/pub/scm/linux/kernel/git/jaegeuk/f2fs-tools.git
Source: %name-%version.tar

Provides: %fsname-utils = %version-%release
Provides: mkfs.%fsname = %version-%release
Provides: fsck.%fsname = %version-%release
Provides: dump.%fsname = %version-%release

BuildRequires: libuuid-devel
BuildRequires: libselinux-devel
BuildRequires: libblkid-devel

%description
NAND flash memory-based storage devices, such as SSD, and SD cards,
have been widely being used for ranging from mobile to server systems.
Since they are known to have different characteristics from the
conventional rotational disks,a file system, an upper layer to
the storage device, should adapt to the changes
from the sketch.

F2FS is a new file system carefully designed for the
NAND flash memory-based storage devices.
We chose a log structure file system approach,
but we tried to adapt it to the new form of storage.
Also we remedy some known issues of the very old log
structured file system, such as snowball effect
of wandering tree and high cleaning overhead.

Because a NAND-based storage device shows different characteristics
according to its internal geometry or flash memory management
scheme aka FTL, we add various parameters not only for configuring
on-disk layout, but also for selecting allocation
and cleaning algorithms.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains the libraries needed to develop applications
that use %name


%prep
%setup

sed -i 's/AC_PROG_LIBTOOL/LT_INIT/' configure.ac


%build
%autoreconf
%configure \
%if_enabled shared
	--disable-static --enable-shared \
%else
	--enable-static --disable-shared \
%endif
	--with-gnu-ld
%make_build


%install
%makeinstall_std
mkdir -m 755 -p %buildroot%_includedir
install -m 644 include/f2fs_fs.h %buildroot%_includedir
install -m 644 mkfs/f2fs_format_utils.h %buildroot%_includedir


%files
%doc COPYING AUTHORS ChangeLog
%_sbindir/*
%_man8dir/*
%if_enabled shared
%_libdir/*.so.*
%else
%exclude %_libdir
%endif

%files devel
%_includedir/*.h
%if_enabled shared
%_libdir/*.so
%endif

%changelog
