# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: far2l
Version: 2.6.5
Release: alt2

Summary: Linux port of FAR v2

Group: File tools
License: GPL-2.0
URL: https://github.com/elfmz/far2l
VCS: https://github.com/elfmz/far2l.git

# Source-url: https://github.com/elfmz/far2l/archive/refs/tags/v_%version.tar.gz
Source: %name-%version.tar
# https://github.com/elfmz/far2l/issues/2744
Patch: fix-input-non-ASCII-with-wxGTK3.2.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: glib2-devel
BuildRequires: libwxGTK3.2-devel
BuildRequires: libuchardet-devel
BuildRequires: libspdlog-devel
BuildRequires: libarchive-devel
BuildRequires: libpcre-devel
BuildRequires: libssl-devel
BuildRequires: libssh-devel
BuildRequires: libnfs-devel
BuildRequires: libsmbclient-devel
BuildRequires: libneon-devel
BuildRequires: libxerces-c-devel
BuildRequires: libXi-devel
BuildRequires: libX11-devel
BuildRequires: libxml2-devel

# skip optional requires from /usr/share/far2l scripts
%filter_from_requires /^sudo/d
%filter_from_requires /^rpm/d
%filter_from_requires /^dpkg/d
%filter_from_requires /^pandoc/d
%filter_from_requires /^catdoc/d
%filter_from_requires /^poppler/d
%filter_from_requires /^notify-send/d
%filter_from_requires /^fdisk/d
%filter_from_requires /^gdisk/d
%filter_from_requires /^gnupg/d
%filter_from_requires /^universal-ctags/d
%filter_from_requires /^perl-Image-ExifTool/d
%filter_from_requires /^gnustep-Backbone$/d
%filter_from_requires /^git-diff-highlight$/d
%filter_from_requires /^plasma5-kde-cli-tools/d
%filter_from_requires /^kde-cli-tools/d

%description
Linux port of FAR v2.
BETA VERSION.
Use on your own risk!
Plug-ins that are currently working: NetRocks (SFTP/SCP/FTP/FTPS/SMB/NFS/WebDAV),
colorer, multiarc, tmppanel, align, autowrap, drawline, editcase, SimpleIndent,
Calculator, Python (optional scripting support).

Used code from projects:
- FAR for Windows and some of its plugins
- WINE
- ANSICON
- Portable UnRAR
- 7z ANSI-C Decoder
- utf-cpp by ww898

%prep
%setup
%autopatch -p1

%build
%cmake \
	-DPCRE_INCLUDE_DIR=%_includedir/pcre \
	-DPYTHON=no

%cmake_build

%install
%cmake_install

# do not show in application menu
desktop-file-edit --set-key=OnlyShowIn --set-value="" %buildroot%_desktopdir/far2l-tty.desktop
desktop-file-edit --set-key=OnlyShowIn --set-value="" %buildroot%_desktopdir/far2ledit.desktop
desktop-file-edit --set-key=OnlyShowIn --set-value="" %buildroot%_desktopdir/far2ledit-tty.desktop

%files
%_bindir/%name
%_bindir/%{name}edit
%_libexecdir/%name/
%_datadir/%name/
%_datadir/bash-completion/completions/far2l
%_desktopdir/far2l.desktop
%_desktopdir/far2l-tty.desktop
%_desktopdir/far2ledit-tty.desktop
%_desktopdir/far2ledit.desktop
%_iconsdir/hicolor/*/apps/*.svg
%_iconsdir/far2l.svg
%_iconsdir/far2ledit.svg
%_mandir/ru/man1/far2l.*
%_man1dir/far2l.*

%changelog
