Name: fastfetch
Version: 2.43.0
Release: alt1
Summary: Like neofetch, but much faster because written in c

License: MIT
Group: Monitoring
Url: https://github.com/LinusDierheimer/fastfetch
Packager: Artyom Bystrov <arbars@altlinux.org>

Source: %url/archive/%version/%name-%version.tar.gz

BuildRequires: cmake
BuildRequires: gcc-c++ ctest
BuildRequires: libpci-devel
BuildRequires: wayland-devel
BuildRequires: libwayland-client-devel
BuildRequires: libxcb-devel
BuildRequires: libXrandr-devel
BuildRequires: libdconf-devel
BuildRequires: libdbus-devel
BuildRequires: libsqlite3-devel
BuildRequires: ImageMagick-devel
BuildRequires: zlib-devel
BuildRequires: libglvnd-devel
BuildRequires: libOSMesa-devel
BuildRequires: libxfconf-devel
BuildRequires: glib2-devel
BuildRequires: ocl-icd-devel
BuildRequires: rpm-devel
BuildRequires: libvulkan-devel
BuildRequires: libXau-devel
BuildRequires: libpcre2-devel
BuildRequires: libzstd-devel
BuildRequires: libffi-devel
BuildRequires: libdrm-devel
BuildRequires: librpm-devel
BuildRequires: libelf-devel

BuildRequires: chafa-devel

%description
fastfetch is a neofetch-like tool for fetching system information and
displaying them in a pretty way. It is written in c to achieve much better
performance, in return only Linux and Android are supported. It also uses
mechanisms like multithreading and caching to finish as fast as possible.

%package bash-completion
Group: Monitoring
Summary: Bash completion files for %name
Requires: bash-completion
Requires: %name = %version-%release
BuildArch: noarch

%description bash-completion
%summary

%prep
%setup

%build
%cmake -D \
    BUILD_TESTS=ON \
    ENABLE_WAYLAND=ON \
    ENABLE_DRM=ON \
    ENABLE_DRM_AMDGPU=ON \
    ENABLE_RPM=ON
%cmake_build

%check
pushd %_cmake__builddir
ctest
popd

%install
%cmake_install

%files
%doc LICENSE
%doc README.md
%_bindir/%name
%_bindir/flashfetch
%_datadir/%name/
%_datadir/licenses/fastfetch/LICENSE
%_man1dir/%name.1.xz

%files bash-completion
%_datadir/bash-completion/completions/%name
%_datadir/fish/vendor_completions.d/%name.fish
%_datadir/zsh/site-functions/_fastfetch

%changelog
