Name: featherpad
Version: 1.4.1
Release: alt1.2

Summary: A lightweight Qt5 plain-text editor for Linux
License: GPLv3+
Group: Editors

Url: https://github.com/tsujan/FeatherPad
Source: V%version.tar.gz

BuildPreReq: cmake rpm-build-ninja
BuildRequires: ImageMagick-tools qt5-svg-devel qt5-tools-devel qt5-wayland-devel qt5-x11extras-devel libhunspell-devel


%description
FeatherPad is a lightweight Qt5 plain-text editor for Linux.

* Drag-and-drop support, including tab detachment and attachment;
* X11 virtual desktop awareness
* An optionally permanent search-bar with a different search entry for each tab;
* Instant highlighting of found matches when searching;
* A docked window for text replacement;
* Support for showing line numbers and jumping to a specific line;
* Automatic detection of text encoding as far as possible and optional saving with encoding;
* Syntax highlighting for common programming languages;
* Session management;
* Side-pane mode;
* Printing;
* Text zooming;
* Appropriate but non-interrupting prompts;

%prep
%setup -n FeatherPad-%version

%define _PX 128 16 192 24 256 32 48 64 72 96

%build
%cmake -GNinja
cmake --build "%_cmake__builddir" -j%__nprocs

for n in %_PX; do
	convert featherpad/data/icons/featherpad.svg $n.png
done

%install
%cmake_install

for n in %_PX; do
	install -D $n.png %buildroot%_iconsdir/hicolor/${n}x$n/apps/%name.png
done

%files
%_bindir/*
%_desktopdir/*
%_datadir/%name/*
%_iconsdir/*/*/*/*
%_datadir/metainfo/featherpad.metainfo.xml

%changelog
