Name: ffmpegthumbnailer
Version: 2.2.2
Release: alt1.20221021

Summary: Lightweight video thumbnailer that can be used by file managers
License: GPL-2.0
Group: Graphics

Url: https://github.com/dirkvdb/ffmpegthumbnailer
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: gcc-c++ libavformat-devel libjpeg-devel libpng-devel libswscale-devel cmake libswresample-devel libavfilter-devel libpostproc-devel

%description
Lightweight video thumbnailer that can be used by file managers.

This video thumbnailer can be used to create thumbnails for your
video files. The thumbnailer uses ffmpeg to decode frames from the
video files, so supported videoformats depend on the configuration
flags of ffmpeg.

This thumbnailer was designed to be as fast and lightweight as
possible. The only dependencies are ffmpeg, libpng and libjpeg.

The project also includes a C/C++ library that can be used by
developers to generate thumbnails in their projects.

%package -n lib%name
Summary: Shared libraries for ffmpegthumbnailer
Group: System/Libraries
Obsoletes: lib%{name}3 < %version

%description -n lib%name
This package includes a shared libraries for ffmpegthumbnailer

%package -n lib%name-devel
Summary: Include Files and Libraries mandatory for Development
Group: Development/C++
Requires: libffmpegthumbnailer = %version-%release
Requires: libavutil-devel libavformat-devel libavcodec-devel libswscale-devel cmake

%description -n lib%name-devel
This package includes C/C++ libraries that can be used by
developers to generate thumbnails in their projects

%prep
%setup
%patch -p1

%build
%cmake -DCMAKE_BUILD_TYPE=Release -DENABLE_GIO=ON -DENABLE_THUMBNAILER=ON
%cmake_build

%install
%cmake_install

%files
%doc AUTHORS ChangeLog README
%_bindir/%name
%_datadir/thumbnailers
%_man1dir/*

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_libdir/lib%name.so
%_includedir/lib%name
%_pkgconfigdir/*.pc

%changelog
