
%global import_path github.com/flannel-io/flannel
%global _unpackaged_files_terminate_build 1
%define _libexecdir /usr/libexec

Name: flannel
Version: 0.27.3
Release: alt1

Summary: flannel is a network fabric for containers
License: Apache-2.0
Group: Development/Other
Url: https://github.com/flannel-io/flannel
ExclusiveArch: %go_arches

Source: %name-%version.tar
Source1: flanneld.sysconfig
Source2: flanneld.service
Source3: flannel-docker.conf
Source4: flannel-tmpfiles.conf
Patch: %name-%version.patch

BuildRequires(pre): rpm-build-golang
BuildRequires: /proc

%description
Flannel is a simple and easy way to configure
a layer 3 network fabric designed for Kubernetes.

%prep
%setup
%patch -p1

%build
export GOFLAGS="-mod=vendor"

CGO_ENABLED=1 go build -ldflags " \
    -X %import_path/pkg/version.Version=%version \
    " -o dist ./...

%install
install -D -p -m 755 dist/flannel %buildroot%_sbindir/flanneld
install -D -p -m 644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/flanneld
install -D -p -m 644 %SOURCE2 %buildroot%_unitdir/flanneld.service
install -D -p -m 644 %SOURCE3 %buildroot%_unitdir/docker.service.d/flannel.conf
install -D -p -m 755 dist/mk-docker-opts.sh %buildroot%_libexecdir/flannel/mk-docker-opts.sh
install -D -p -m 0755 %SOURCE4 %buildroot%_tmpfilesdir/%name.conf

%files
%doc LICENSE README.md Documentation
%_sbindir/flanneld
%_unitdir/flanneld.service
%_unitdir/docker.service.d/flannel.conf
%dir %_libexecdir/flannel
%_libexecdir/flannel/mk-docker-opts.sh
%config(noreplace) %_sysconfdir/sysconfig/flanneld
%_tmpfilesdir/%name.conf

%changelog
