%def_enable docs

Name: fontforge
Version: 20230101
Release: alt2

Summary: FontForge -- font editor
License: BSD
Group: Publishing

Url: http://fontforge.sourceforge.net/
# Source-url: https://github.com/fontforge/fontforge/archive/%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3 rpm-macros-cmake 
BuildRequires: cmake gcc-c++
BuildRequires: libgtk+3-devel libgio-devel
BuildRequires: python3-module-setuptools

BuildRequires: libreadline-devel libspiro-devel libuninameslist-devel
BuildRequires: libxml2-devel libfreetype-devel zlib-devel
BuildRequires: libgif-devel libjpeg-devel libtiff-devel libpng-devel libwoff2-devel
#BuildRequires: libuthash-devel gnulib

%if_enabled docs
BuildRequires: python3-module-sphinx
%endif

%add_python3_lib_path %_datadir/%name/python

Requires: lib%name = %EVR

%description
FontForge allows the user to create and modify 
Type 1 (postscript) and true type fonts.
User can save fonts in different postscript 
formats and generate bitmaps.

%description -l ru_RU.UTF-8
FontForge позволяет пользователям создавать и изменять 
шрифты форматов Type1 (postscipt) и True Type. 
Возможно сохранять шрифты в различных
форматах postscript и генерировать 
растровые изображения шрифтов.

%package -n lib%name
Summary: FontForge shared library
Group: System/Libraries

%package -n lib%name-devel
Summary: FontForge development files
Group: Development/C
Requires: lib%name = %EVR

%package -n python3-module-%name
Summary: FontForge python module
Group: Development/Python3
Requires: lib%name = %EVR

%description -n python3-module-%name
FontForge python module

%if_enabled docs
%package docs
Summary: FontForge documentations
Group: Publishing

%description docs
FontForge documentations
%endif

%description -n lib%name
FontForge shared library

%description -n lib%name-devel
FontForge development files

%prep
%setup
sed -i "s|sphinx-build|sphinx-build-3|" cmake/packages/FindSphinx.cmake
%ifarch %e2k
# lcc 1.24.11 doesn't do that; mcst#....
sed -i "s|-Werror=int-conversion||" CMakeLists.txt
%endif

%build
%cmake
%cmake_build

%install
%cmakeinstall_std

%find_lang FontForge

%files -f FontForge.lang
%doc LICENSE
%_bindir/*
%_datadir/%name/
%_man1dir/*
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*.*
%_datadir/mime/packages/*
#_datadir/pixmaps/*
%_datadir/metainfo/*

%files -n lib%name
%_libdir/libfontforge.so.*

%files -n lib%name-devel
%_libdir/*.so
#%_includedir/%name/
#%_pkgconfigdir/*.pc

%files -n python3-module-%name
%python3_sitelibdir/*.so

%if_enabled docs
%files docs
%_docdir/%name/
%endif


%changelog
