%def_with xfs
%define fname  cyr_rfx
%define cname  cp1251

%define origname windows-1251
%define oversion 1.1

%define __bitmapdir %_bitmapfontsdir/%fname-%cname

Name: fonts-bitmap-cyr_rfx-cp1251
Version: 1.1a
Release: alt9

Summary: Cyrillic bitmap fonts for the X Window System in microsoft-cp1251 encoding

License: distributable
Group: System/Fonts/X11 bitmap
Url: http://www.inp.nsk.su/~bolkhov/files/fonts/cyr-rfx/00index.en.html

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://www.inp.nsk.su/~bolkhov/files/fonts/cyr-rfx/srctgz/cyr-rfx-%origname-%oversion.bdfs.tar.bz2
Source1: Makefile.fonts
Source2: fonts.dir.75dpi
Source3: fonts.dir.misc
Source4: fonts.alias.misc.1251
Source5: fonts.alias.75dpi

BuildArch: noarch

BuildRequires: unzip mkfontdir bdftopcf xorg-font-utils xorg-font-encodings rpm-build-fonts
PreReq: fontconfig >= 2.4.2

Obsoletes: XFree86-%fname-fonts-%cname
Obsoletes: cyr_rfx-windows-1251
Requires: fonts-bitmap-%fname-%cname-misc = %EVR
Requires: fonts-bitmap-%fname-%cname-75dpi = %EVR

%description
Collection of cyrillic raster fonts for X Window System by D. Bolkhovityanov.

%package -n fonts-bitmap-%fname-%cname-misc
Group: System/Fonts/X11 bitmap
Summary: Cyrillic bitmap fonts in microsoft-cp1251 encoding
Conflicts: fonts-bitmap-%fname-%cname < 1.1a-alt7

%description -n fonts-bitmap-%fname-%cname-misc
Collection of cyrillic raster fonts for X Window System  in microsoft-cp1251 encoding
by D. Bolkhovityanov, misc part.

%package -n fonts-bitmap-%fname-%cname-75dpi
Group: System/Fonts/X11 bitmap
Summary: Cyrillic bitmap fonts in microsoft-cp1251 encoding
Conflicts: fonts-bitmap-%fname-%cname < 1.1a-alt7

%description -n fonts-bitmap-%fname-%cname-75dpi
Collection of cyrillic raster fonts for X Window System  in microsoft-cp1251 encoding
by D. Bolkhovityanov, 75dpi part.

%prep
%setup -q -n %origname
for i in misc 75dpi ; do
	cd $i
	sed -i 's/-Adobe/-rfx/g' *.bdf
	sed -i 's/\"Adobe/\"rfx/g' *.bdf
	sed -i 's/windows/microsoft/g' *.bdf
	sed -i 's/-1251/-cp1251/g' *.bdf
	cd -
done
cp %SOURCE1 ./Makefile
cp %SOURCE4 ./misc/fonts.alias
cp %SOURCE5 ./75dpi/fonts.alias

%build
make

%install
mkdir -p %buildroot%__bitmapdir
make FONTDIR=%buildroot%__bitmapdir install
# due bdf in orig dir, make only pcf here
for n in 75dpi misc; do
  mkfontdir -e /usr/share/X11/fonts/encodings %buildroot%__bitmapdir/$n
done

%if_with xfs
mkdir -p %buildroot%_fontpathdir/
ln -s ../../..%__bitmapdir/misc \
	%buildroot%_fontpathdir/bitmap-%fname-%cname-misc:unscaled:pri=10
ln -s ../../..%__bitmapdir/75dpi \
	%buildroot%_fontpathdir/bitmap-%fname-%cname-75dpi:unscaled:pri=10
%endif

%files
%doc doc/*

%files -n fonts-bitmap-%fname-%cname-misc
%if_with xfs
%_fontpathdir/*misc*
%endif
%dir %__bitmapdir/
%__bitmapdir/misc/

%files -n fonts-bitmap-%fname-%cname-75dpi
%if_with xfs
%_fontpathdir/*75dpi*
%endif
%dir %__bitmapdir/
%__bitmapdir/75dpi/

%changelog
