%define oldname liberation-fonts
%global priority 60
%global fontname liberation-narrow
%global fontconf %{priority}-%{fontname}

Name:             fonts-ttf-%fontname
Summary:          Sans-serif Narrow fonts to replace commonly used Microsoft Arial Narrow

Version:          1.07.4
Release:          alt2
# The license of the Liberation Fonts is a EULA that contains GPLv2 and two
# exceptions:
# The first exception is the standard FSF font exception.
# The second exception is an anti-lockdown clause somewhat like the one in
# GPLv3. This license is Free, but GPLv2 and GPLv3 incompatible.
License:          Liberation
Group:            System/Fonts/True type
URL:              http://fedorahosted.org/liberation-fonts/
Source0:          https://fedorahosted.org/releases/l/i/liberation-fonts/%{oldname}-%{version}.tar.gz
Source5:          %{oldname}-narrow.conf
BuildArch:        noarch
BuildRequires:    fontpackages-devel >= 1.13 xorg-x11-font-utils
BuildRequires:    fontforge
BuildRequires: rpm-build-fonts
Source44: import.info

Conflicts: fonts-ttf-liberation < 1.07

%description
The Liberation Fonts are intended to be replacements for the three most \
commonly used fonts on Microsoft systems: Times New Roman, Arial, and Courier \
New.

This is Sans-Serif Narrow TrueType fonts that replaced commonly used Microsoft \
Arial Narrow.

%prep
%setup -q -n %{oldname}-%{version}

%build
make %{?_smp_mflags} 
mv liberation-fonts-ttf-%{version}/* .

%install
%ttf_fonts_install %fontname

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

install -m 0644 -p %{SOURCE5} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}.conf

  ln -s %{_fontconfig_templatedir}/%{fontconf}.conf \
        %{buildroot}%{_fontconfig_confdir}/%{fontconf}.conf

%files -f %fontname.files
%doc License.txt README AUTHORS ChangeLog
%{_fontconfig_templatedir}/*-%{fontname}.conf
%config(noreplace) %{_fontconfig_confdir}/*-%{fontname}.conf

%changelog
