%def_with ffmpeg
# X264 backend not implemented, please review your configuration!
%def_with x264
%def_without directfb
# see https://github.com/FreeRDP/FreeRDP/issues/4348
%def_without gss
%def_without mbedtls

Name: freerdp
Version: 2.11.7
Release: alt3

Group: Networking/Remote access
Summary: Remote Desktop Protocol functionality
License: Apache-2.0
URL: http://www.freerdp.com
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Source1: freerdp-server.service
Source2: freerdp-login.sh
Source3: freerdp-logout.sh
Source4: freerdp.sysconfig
Source5: freerdp-server.pam

Patch0: %name-alt-pam-check.patch
Patch1: %name-alt-connection-scripts.patch
Patch2: %name-alt-use-pam-module-freerdp-server.patch
Patch2000: %name-e2k.patch

Requires: xfreerdp = %EVR
Requires: wlfreerdp = %EVR
Requires: %name-plugins-standard = %EVR

BuildRequires(pre): cmake
BuildRequires: gcc-c++
BuildRequires: extra-cmake-modules
BuildRequires: docbook-style-xsl git-core xmlto libpcre-devel
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(libpcsclite)
BuildRequires: pkgconfig(libsystemd)
BuildRequires: pkgconfig(openssl)
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(wayland-scanner)
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(xcursor)
BuildRequires: pkgconfig(xdamage)
BuildRequires: pkgconfig(xext)
BuildRequires: pkgconfig(xtst)
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(xinerama)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(xkbfile)
BuildRequires: pkgconfig(xrandr)
BuildRequires: pkgconfig(xv)
BuildRequires: pkgconfig(gstreamer-1.0)
BuildRequires: pkgconfig(gstreamer-plugins-base-1.0)
BuildRequires: pkgconfig(libpulse)
%{?_with_directfb:BuildRequires: pkgconfig(directfb)}
BuildRequires: libcups-devel libjpeg-devel zlib-devel
%{?_with_ffmpeg:BuildRequires: libavcodec-devel libavutil-devel libswresample-devel}
%{?_with_x264:BuildRequires: libx264-devel}
BuildRequires: libkrb5-devel
BuildRequires: wayland-devel
%if_with mbedtls
BuildRequires: libmbedtls-devel
%endif
BuildRequires: libgsm-devel
BuildRequires: liblame-devel
BuildRequires: libfaad-devel
BuildRequires: libfaac-devel
BuildRequires: libsoxr-devel
BuildRequires: libffi-devel
BuildRequires: liborc-devel
BuildRequires: libicu-devel
BuildRequires: libcairo-devel
BuildRequires: libpixman-devel
BuildRequires: libexpat-devel
BuildRequires: libXdmcp-devel
BuildRequires: bzlib-devel
BuildRequires: libuuid-devel
BuildRequires: libudev-devel
BuildRequires: libusb-devel
BuildRequires: libpam-devel
BuildRequires: libdbus-glib-devel
%ifarch %e2k
BuildRequires: chrpath
%else
BuildRequires: patchelf
%endif
BuildRequires: libopenh264-devel

%description
freerdp implements Remote Desktop Protocol (RDP), used in a number of Microsoft
products. Rdesktop analog.

This is metapackage.

%package -n xfreerdp
Summary: Remote Desktop Protocol client
Group: Networking/Remote access
Requires: lib%name = %EVR

%description -n xfreerdp
xfreerdp is a client for Remote Desktop Protocol (RDP), used in a number of
Microsoft products.

This package contains X11 UI.

%package -n dfreerdp
Summary: Remote Desktop Protocol client
Group: Networking/Remote access
Provides: dfbfreerdp
Requires: lib%name = %EVR

%description -n dfreerdp
dfbfreerdp is a client for Remote Desktop Protocol (RDP), used in a number of
Microsoft products.

This package contains DirectFB UI.

%package -n wlfreerdp
Summary: Remote Desktop Protocol client
Group: Networking/Remote access
Requires: lib%name = %EVR

%description -n wlfreerdp
wlfreerdp is a client for Remote Desktop Protocol (RDP), used in a number of
Microsoft products.

This package contains Wayland UI.

%package -n lib%name
Summary: Core libraries implementing the RDP protocol
Group: System/Libraries

%description -n lib%name
libfreerdp can be embedded in applications.

%package -n lib%name-server
Summary: Remote Desktop Viewer server library
Group: System/Libraries

%description -n lib%name-server
FreeRDP is a client-side implementation of the Remote Desktop Protocol (RDP)
following the Microsoft Open Specifications. This package provides the shared
libraries used by the server.

%package -n libwinpr
Summary: Windows Portable Runtime
Group: System/Libraries

%description -n libwinpr
WinPR provides API compatibility for applications targeting non-Windows
environments. When on Windows, the original native API is being used instead of
the equivalent WinPR implementation, without having to modify the code using it.

%package -n libwinpr-devel
Summary: Windows Portable Runtime development files
Group: Development/C
Requires: libwinpr = %EVR

%description -n libwinpr-devel
The libwinpr-devel package contains libraries and header files for
developing applications that use libwinpr.

%package -n libuwac
Summary: Use wayland as a client
Group: System/Libraries

%description -n libuwac
Remote Desktop Toolkit library. Contains the libuwac libraries.

%package -n     libuwac-devel
Summary: Remote Desktop Toolkit libuwac development files
Group: Development/C
Requires: libuwac = %EVR

%description -n libuwac-devel
The libuwac-devel package contains libraries and header files for
developing applications that use libuwac.

%package plugins-standard
Summary: Plugins for handling the standard RDP channels
Group: Networking/Remote access
Requires: lib%name = %EVR

%description plugins-standard
A set of plugins to the channel manager implementing the standard virtual
channels extending RDP core functionality.  For example, sounds, clipboard
sync, disk/printer redirection, etc.

%package -n lib%name-devel
Summary: Libraries and header files for embedding and extending freerdp
Group: Development/C
Requires: lib%name = %EVR
Provides: freerdp-devel
Obsoletes: freerdp-devel

%description -n lib%name-devel
Header files and unversioned libraries for libfreerdp.

%package server
Summary: Server support for %{name}
Group: Networking/Remote access
Requires: lib%name = %EVR
Requires: lib%name-server = %EVR

%description server
The %{name}-server package contains servers which can export a desktop via
the RDP protocol.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%ifarch %e2k
%patch2000 -p1
sed -i '/set(CMAKE_INSTALL_RPATH /d' CMakeLists.txt
%endif

%build
%cmake \
    -DCMAKE_BUILD_TYPE=Release \
    -DBUILD_SHARED_LIBS=ON \
    -DCMAKE_SKIP_RPATH=FALSE \
%ifarch %e2k
    -DCMAKE_SKIP_INSTALL_RPATH=FALSE \
    -DCMAKE_INSTALL_RPATH:PATH='$ORIGIN' \
%else
    -DCMAKE_SKIP_INSTALL_RPATH=TRUE \
%endif
    -DWITH_ALSA=ON \
    -DWITH_CAIRO=ON \
    -DWITH_CUPS=ON \
    -DWITH_CHANNELS=ON \
    -DBUILTIN_CHANNELS=OFF \
    -DWITH_CLIENT_CHANNELS=ON \
    -DWITH_CLIENT=ON \
    %{?_without_directfb:-DWITH_DIRECTFB=OFF} \
    %{?_without_ffmpeg:-DWITH_FFMPEG=OFF} \
%if_with x264
    -DWITH_X264=ON \
%else
    -DWITH_X264=OFF \
%endif
    -DWITH_GSM=ON \
    %{?_without_gss:-DWITH_KERBEROS=OFF} \
    -DWITH_FAAC=ON \
    -DWITH_FAAD2=ON \
    -DWITH_GSTREAMER_1_0=ON \
    -DGSTREAMER_1_0_INCLUDE_DIRS=%{_includedir}/gstreamer-1.0 \
    -DWITH_ICU=ON \
    -DWITH_IPP=OFF \
    -DWITH_JPEG=ON \
    -DWITH_LAME=ON \
    -DWITH_LIBRARY_VERSIONING=ON \
    -DWITH_MANPAGES=ON \
    %{?_with_mbetls:-DWITH_MBEDTLS=ON} \
    -DWITH_OPENH264=ON \
    -DWITH_OPENSSL=ON \
    -DWITH_PCSC=ON \
    -DWITH_PULSE=ON \
    -DWITH_SERVER=ON \
    -DWITH_SERVER_INTERFACE=ON \
    -DWITH_SERVER_CHANNELS=ON \
    -DWITH_SHADOW_X11=ON \
    -DWITH_SHADOW_MAC=ON \
    -DWITH_XTEST=ON \
    -DCHANNEL_URBDRC=ON \
    -DCHANNEL_URBDRC_CLIENT=ON \
    -DWITH_SHADOW_X11=ON \
    -DWITH_SHADOW_MAC=ON \
    -DWITH_SOXR=ON \
    -DWITH_WAYLAND=ON \
    -DWITH_X11=ON \
    -DWITH_XCURSOR=ON \
    -DWITH_XEXT=ON \
    -DWITH_XI=ON \
    -DWITH_XINERAMA=ON \
    -DWITH_XKBFILE=ON \
    -DWITH_XRENDER=ON \
    -DWITH_XV=ON \
    -DWITH_ZLIB=ON \
%ifarch x86_64 %e2k
    -DWITH_SSE2=ON \
%else
    -DWITH_SSE2=OFF \
%endif
%ifarch x86_64
    -DWITH_VAAPI=%{?_with_ffmpeg:ON}%{?!_with_ffmpeg:OFF} \
%endif
%ifarch armh
    -DARM_FP_ABI=hard \
    -DWITH_NEON=OFF \
%endif
%ifarch %e2k
    -DCMAKE_C_FLAGS_RELEASE="-O%_optlevel -DNDEBUG"
%endif
    #

%cmake_build

%install
%cmakeinstall_std

rm -f %buildroot%_libdir/*.a \
      %buildroot%_libdir/freerdp/*.a

# workaround, add compat
ln -s freerdp2.pc %buildroot%_pkgconfigdir/freerdp.pc

%ifarch %e2k
# patchelf damages e2k binaries
setrpath="chrpath -r"
%else
setrpath="patchelf --set-rpath"
%endif

# Set rpath to %_libdir/freerdp2 for freerdp-proxy executable
$setrpath %_libdir/freerdp2 %buildroot%_bindir/freerdp-proxy

# Set rpath to library
$setrpath '$ORIGIN' %buildroot%_libdir/freerdp2/liburbdrc-client-libusb.so

# Install freerdp-server.service
install -Dpm0644 %SOURCE1 %buildroot%_libexecdir/systemd/user/freerdp-server.service

# Install connection scripts
install -Dpm0755 %SOURCE2 %buildroot%_sysconfdir/freerdp/freerdp-login.sh
install -Dpm0755 %SOURCE3 %buildroot%_sysconfdir/freerdp/freerdp-logout.sh

# Install default configuration for freerdp-server.service
install -Dpm0644 %SOURCE4 %buildroot%_sysconfdir/sysconfig/freerdp-server

# Install PAM module
install -Dpm0644 %SOURCE5 %buildroot%_sysconfdir/pam.d/freerdp-server

%files

%files -n xfreerdp
%_bindir/xfreerdp
%_man1dir/xfreerdp*
%_bindir/winpr-*
%_man1dir/winpr-*

%files -n wlfreerdp
%_bindir/wlfreerdp
%_man1dir/wlfreerdp*

%if_with directfb
%files -n dfreerdp
%_bindir/dfreerdp
%endif

%files server
%_bindir/freerdp-proxy
%config(noreplace) %_libexecdir/systemd/user/freerdp-server.service
%config(noreplace) %attr(0755, root, root) %_sysconfdir/freerdp/freerdp-login.sh
%config(noreplace) %attr(0755, root, root) %_sysconfdir/freerdp/freerdp-logout.sh
%config(noreplace) %_sysconfdir/sysconfig/freerdp-server
%config(noreplace) %_sysconfdir/pam.d/freerdp-server
%attr(2711, root, chkpwd) %_bindir/freerdp-shadow-cli
%_man1dir/freerdp-shadow-cli.*

%files -n lib%name
%doc LICENSE README.md ChangeLog
%_libdir/lib%{name}2.so.*
%_libdir/lib%{name}-client2.so.*
%dir %_libdir/freerdp*
%_man7dir/wlog*

%files -n lib%name-server
%_libdir/lib%{name}-server2.so.*
%_libdir/lib%{name}-shadow-subsystem2.so.*
%_libdir/lib%{name}-shadow2.so.*

%files plugins-standard
%_libdir/freerdp*/*.so

%files -n libwinpr
%_libdir/libwinpr2.so.*
%_libdir/libwinpr-tools2.so.*

%files -n libwinpr-devel
%_libdir/cmake/WinPR*
%_includedir/winpr*
%_libdir/libwinpr2.so
%_libdir/libwinpr-tools2.so
%_pkgconfigdir/winpr*.pc

%files -n libuwac
%_libdir/libuwac0.so.*

%files -n libuwac-devel
%_libdir/cmake/uwac*
%_includedir/uwac*
%_libdir/libuwac0.so
%_pkgconfigdir/uwac*.pc

%files -n lib%name-devel
%_libdir/cmake/FreeRDP*
%_includedir/%{name}*
%_libdir/lib%{name}*.so
%_pkgconfigdir/freerdp*.pc

%changelog
