%def_disable snapshot
%def_disable static
%def_enable docs
%def_enable deprecated
%def_enable check

Name: fribidi
Version: 1.0.16
Release: alt1

Summary: Bi-directional scripts support
License: LGPL-2.0-or-later and UCD
Group: System/Internationalization
Url: https://github.com/%name/%name

Vcs: https://github.com/fribidi/fribidi.git

%if_disabled snapshot
Source: %url/releases/download/v%version/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: lib%name = %EVR

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
%{?_enable_docs:BuildRequires: c2man}
%{?_enabled_static:BuildRequires: glibc-devel-static}

%package -n lib%name
Summary: Library implementing the Unicode BiDi algorithm
Group: System/Libraries

%package -n lib%name-devel
Summary: Library implementing the Unicode BiDi algorithm
Group: Development/C
Requires: lib%name = %EVR
Provides: %name-devel = %version
Obsoletes: %name-devel

%description
Bi-directional scripts support.

%package -n lib%name-devel-static
Summary: Library implementing the Unicode BiDi algorithm
Group: Development/C
Requires: lib%name-devel = %EVR

%description -n lib%name
A library to handle bidirectional scripts (eg hebrew, arabic), so that
the display is done in the proper way; while the text data itself is
always written in logical order.
The library uses unicode internally.

%description -n lib%name-devel
The libfribidi-devel package includes  header files
for the fribidi package.

Install libfribidi-devel if you want to develop programs which will use
fribidi.

%description -n lib%name-devel-static
The libfribidi-devel-static package includes the static libraries
for the fribidi package.

Install libfribidi-devel-static if you want to develop statically linked
programs which will use fribidi.

%prep
%setup
# empty manpages in 1.0.12 tarball
#rm -f doc/{c2man.stamp,%{name}_*.3}

%build
%meson \
    %{?_enable_static:--default-library=both} \
    %{subst_enable_meson_bool deprecated deprecated} \
    %{subst_enable_meson_bool docs docs}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_bindir/*
%doc README AUTHORS TODO THANKS NEWS
%{?_disable_snapshot:%doc ChangeLog}

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%{?_enable_docs:%_man3dir/*.3*}

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
