%define oname cryfs
Name: fuse-cryfs
Version: 0.11.4
Release: alt1

Summary: Cryptographic filesystem for the cloud

License: LGPLv2
Group: System/Kernel and hardware
Url: https://www.cryfs.org/

Requires: fuse

# Source-url: https://github.com/cryfs/cryfs/archive/%version.tar.gz
Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %name-%version.tar

ExcludeArch: armh

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake >= 3.10
BuildRequires: boost-devel boost-devel-headers boost-filesystem-devel boost-program_options-devel boost-asio-devel
#BuildRequires: boost-devel-static
BuildRequires: libcryptopp-devel
BuildRequires: libcurl-devel
BuildRequires: libfuse-devel >= 2.8.6
BuildRequires: libssl-devel
BuildRequires: librange-v3-devel >= 0.11.0
BuildRequires: libspdlog-devel >= 1.8.5

BuildRequires: gcc-c++
BuildRequires: libgomp-devel
BuildRequires: python3

%description
CryFS encrypts your files, so you can safely store them anywhere.
It works well together with cloud services
like Dropbox, iCloud, OneDrive and others.
See https://www.cryfs.org.

%prep
%setup

%build
%cmake -DBUILD_TESTING=off -DBoost_INCLUDE_DIRS=%_includedir/boost -DBoost_USE_STATIC_LIBS=off \
       -DCMAKE_BUILD_TYPE=RELEASE \
       -DDEPENDENCY_CONFIG=cmake-utils/DependenciesFromLocalSystem.cmake
%cmake_build

%install
%cmake_install

%files
%_bindir/cryfs
%_bindir/cryfs-unmount
%_man1dir/*

%changelog
