Name:    gcompris-qt
Version: 25.1.1
Release: alt1
Summary: Educational suite for kids 2-10 years old
Summary(ru_RU.UTF8): Набор образовательных игр для детей от 2 до 10 лет

License: GPL-3.0
Group:   Games/Educational
URL:     http://www.gcompris.net

Source:  %name-%version.tar
Source1: submodules.tar
#Source2: gcompris_qt.po
#Source3: gcompris_voices.po

Patch0: gcompris-qt-box2d-disable-stripping.patch

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: extra-cmake-modules
BuildRequires: qt6-base-devel
BuildRequires: qt6-declarative-devel
BuildRequires: qt6-multimedia-devel
BuildRequires: qt6-sensors-devel
BuildRequires: qt6-svg-devel
BuildRequires: qt6-tools-devel
BuildRequires: libssl-devel
#BuildRequires: kf6-kdoctools-devel
#BuildRequires: kf6-kdoctools-devel-static
BuildRequires: qt6-charts-devel
BuildRequires: qt6-wayland-devel
BuildRequires: libvulkan-devel
BuildRequires: chrpath

Requires: libqt6-multimedia
Requires: libqt6-svg
Requires: libqt6-multimediaquick
Requires: libqt6-quickcontrols2
Requires: libqt6-quickparticles
Requires: qml6(QtSensors)
Requires: chess sqlite3 gnucap tuxpaint
# needed for sound support
Requires: gst-plugins-base1.0

%description
GCompris / I Got IT is an educationnal game for children starting at 2.
More than 150 different activities are proposed:
* Click on the animals => learn the mouse/click usage
* Type the falling letters => learn the keyboard usage
* Falling Dices
* Falling words
* Basic algebra
* Time learning with an analog clock
* Puzzle game with famous paintings
* Drive Plane to catch clouds in increasing number
* Balance the scales
* And much more...

%description -l ru_RU.UTF8
GCompris - набор образовательных игр и программ для детей от двух лет
Предоставляется более 150 различных обучающих игр:
* Обучение использованию мыши
* Обучение использованию клавиатуры
* Падающие кубики
* Падающие слова
* Основы счёта
* Обучение времени
* Паззл с известными картинами
* На летящем самолёте ловить облака с возрастающими цифрами
* И многое другое...

%prep
%setup
tar xf %SOURCE1
%patch0 -p1
#install -Dpm0644 %SOURCE2 poqm/ru/gcompris_qt.po
#install -Dpm0644 %SOURCE3 po/ru/gcompris_voices.po
# Remove geography activity due to non actial maps
subst '/geography/d' src/activities/activities.txt
# Adapt balancebox activity to QtSensors 6.0 (ALT #53765)
subst 's/QtSensors 5.0 /QtSensors 6.0/' src/activities/balancebox/Balancebox.qml

%build
export LANG=en_US.UTF-8
%cmake -GNinja \
       -DKDE_INSTALL_APPDIR=%_desktopdir \
       -DKDE_INSTALL_METAINFODIR=%_datadir/metainfo
%ninja_build -C "%_cmake__builddir"

%install
export LANG=en_US.UTF-8
%ninja_install -C "%_cmake__builddir"
chrpath -d %buildroot%_libexecdir/qml/Box2D.2.0/libqmlbox2d.so
%find_lang --with-qt %name

%files -f %name.lang
%doc README README.md
%_bindir/%name
%_libexecdir/qml/Box2D.2.0
%dir %_datadir/%name
%dir %_datadir/%name/translations
%_datadir/%name/rcc
%_desktopdir/*.desktop
%_datadir/metainfo/*.appdata.xml
%_iconsdir/hicolor/*/apps/%name.*

%changelog
