%define _unpackaged_files_terminate_build 1
%def_without docs
%def_without check

# TODO: enable system libtiff when it will support BigTiff (from 4.0?)
%def_without libtiff
%def_without geotiff

%define sover 36

Name: gdal
Version: 3.10.2
Release: alt2

Summary: The Geospatial Data Abstraction Library (GDAL)
License: MIT
Group: Sciences/Geosciences

URL: http://www.gdal.org
Packager: ALT QA Team <qa@packages.altlinux.org>
# ftp://ftp.remotesensing.org/%name/%version/%name-%version.tar.xz
Source: %name-%version.tar
Patch: %name-2.2.3-alt-mysql8-transition.patch

%define libname lib%name

BuildRequires(pre): rpm-build-ninja
BuildRequires: doxygen gcc-c++ libMySQL-devel libcfitsio-devel libcurl-devel
BuildRequires: libexpat-devel libgeos-devel libgif-devel libhdf5-devel
BuildRequires: libjpeg-devel libpng-devel libsqlite3-devel
BuildRequires: libunixODBC-devel postgresql-devel swig zlib-devel

BuildRequires: chrpath libnetcdf-devel
BuildRequires: libproj-devel
BuildRequires: libxerces-c-devel
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: libnumpy-py3-devel
BuildRequires: libtiff-devel libgeotiff-devel libxml2-devel libzstd-devel
BuildRequires: libqhull-devel libpcre2-devel libspatialite-devel
BuildRequires: librasterlite2-devel libwebp-devel freexl-devel
BuildRequires: libblas-devel liblapack-devel libhdf5-devel libkea-devel
BuildRequires: pkgconfig(OpenCL) liblzma-devel libheif-devel
BuildRequires: libopenjpeg2.0-devel libpoppler-devel
%ifarch %ix86 x86_64
BuildRequires: libarmadillo-devel
%endif
%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx_rtd_theme
BuildRequires: python3-module-breathe
BuildRequires: python3-module-sphinx-bootstrap-theme
BuildRequires: python3-module-sphinxcontrib-spelling
BuildRequires: python3-module-recommonmark
%endif
%if_with check
BuildRequires: ctest
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy-testing
BuildRequires: /proc
%endif

%description
The Geospatial Data Abstraction Library (GDAL) is a unifying
C/C++ API for accessing raster geospatial data, and currently
includes formats like GeoTIFF, Erdas Imagine, Arc/Info
Binary, CEOS, DTED, GXF, and SDTS. It is intended to provide
efficient access, suitable for use in viewer applications,
and also attempts to preserve coordinate systems and metadata.
Python, C, and C++ interfaces are available.

%if_with docs
%package doc
Summary: Documentation for GDAL/OGR
Group: Documentation
BuildArch: noarch

%description doc
This package contains documentation for the GDAL/OGR library
and utilities.
%endif

%package plugins
Summary: Plugins for GDAL
Group: Sciences/Geosciences
Conflicts: libgdal < 3.9.0

%description plugins
This package contains various pluginsfor GDAL.

%package scripts
Summary: Scripts for GDAL
Group: Sciences/Geosciences
BuildArch: noarch

%description scripts
This package contains various scripts for GDAL (written in python)

%package -n %libname%sover
Summary: Libraries required for the GDAL library
Group: Sciences/Geosciences
Requires: %name-plugins = %EVR
Obsoletes: libgdal < 3.9.0

%description -n %libname%sover
Libraries required for the GDAL library

%package -n %libname-devel
Summary: Development files for using the GDAL library
Group: Development/C

%description -n lib%name-devel
Development files for using the GDAL library

%package -n python3-module-%name
Summary: The Python bindings for the GDAL library
Group: Development/Python3
Requires: %libname%sover = %version
Requires: %name
Provides: python3-module-osgeo = %version

%description -n python3-module-%name
Python module for %name.

%prep
%setup
%patch -p0
%ifarch %e2k
# mcst#9339 as of 3.10.x vs lcc 1.29.06
sed -i '/large_power_of_5\[\] =/s/\[\]/[5]/' third_party/fast_float/bigint.h
sed -i -E 's/^(.*<Image>\(rc, )isBigTIFF/bool fix=isBigTIFF;\1fix/' third_party/libertiff/libertiff.hpp
sed -i -E 's/(m_o(Map.*|Conf))\{\};/\1={};/' frmts/zarr/zarr.h ogr/ogrsf_frmts/gmlas/ogr_gmlas.h
sed -i -E 's/(m_anArrow.*)\{\};/\1={};/' ogr/ogrsf_frmts/generic/ograrrowarrayhelper.h
%endif

%build
%add_optflags -fno-strict-aliasing
%cmake -GNinja \
    -DBUILD_SHARED_LIBS:BOOL=ON \
    -DCMAKE_INSTALL_INCLUDEDIR:PATH=%_includedir/%name \
    -DGDAL_USE_EXTERNAL_LIBS=ON \
    -DGDAL_USE_CFITSIO=OFF \
    -DGDAL_USE_CURL=ON \
    -DGDAL_USE_EXPAT=ON \
    -DGDAL_USE_FREEXL=ON \
    -DGDAL_USE_GEOS=ON \
    -DGDAL_USE_GIF=ON \
    -DGDAL_USE_HDF5=ON \
    -DGDAL_USE_HEIF=ON \
    -DGDAL_USE_JPEG=ON \
    -DGDAL_USE_JSONC_INTERNAL=ON \
    -DGDAL_USE_LIBLZMA=ON \
    -DGDAL_USE_LIBXML2=ON \
    -DGDAL_USE_MYSQL=ON \
    -DGDAL_USE_NETCDF=ON \
    -DGDAL_USE_ODBC=ON \
    -DGDAL_USE_OGDI=OFF \
    -DGDAL_USE_OPENCL=ON \
    -DGDAL_USE_OPENJPEG=ON \
    -DGDAL_USE_PCRE=ON \
    -DGDAL_USE_PCRE2=ON \
    -DGDAL_USE_PNG=ON \
    -DGDAL_USE_POPPLER=ON \
    -DGDAL_USE_POSTGRESQL=ON \
    -DGDAL_USE_QHULL=ON \
    -DGDAL_USE_SHAPELIB=OFF \
    -DGDAL_USE_SPATIALITE=ON \
    -DGDAL_USE_TIFF=ON \
    -DGDAL_USE_WEBP=ON \
    -DGDAL_USE_XERCESC=ON \
    -DGDAL_USE_ZLIB=ON \
    -DGDAL_USE_ZSTD=ON \
    -DOGR_BUILD_OPTIONAL_DRIVERS=ON \
    -DBUILD_TESTING=OFF

%ninja_build -C "%_cmake__builddir"
%if_with docs
export LD_LIBRARY_PATH="$PWD/%_cmake__builddir"
export PYTHONPATH="$PWD/%_cmake__builddir/swig/python"
# latexmk isn't available to make gdal.pdf
sed -i \
    "s|ln -sf ../latex/gdal.pdf build/html|#ln -sf ../latex/gdal.pdf build/html|" \
    doc/Makefile
make SPHINXBUILD="sphinx-build-3" -C doc html
make SPHINXBUILD="sphinx-build-3" -C doc man
%endif

%install
%ninja_install -C "%_cmake__builddir"
%if_with docs
mkdir -p %buildroot%_man1dir
install -m 644 doc/build/man/*.1 %buildroot%_man1dir
%endif

%check
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:%buildroot%_libdir
export GDAL_DATA=%buildroot%_datadir/%name
export PYTHONPATH=%buildroot%python3_sitelibdir
export GDAL_DOWNLOAD_TEST_DATA=0
pushd %_cmake__builddir/autotest
py.test-3 -v
popd

%files
%_datadir/%name
%_bindir/pct2rgb
%_bindir/rgb2pct
%_bindir/ogr*
%_bindir/gdal*
%_bindir/nearblack
%_bindir/gnmanalyse
%_bindir/gnmmanage
%_bindir/sozip
%exclude %_bindir/gdal-config
%exclude %_bindir/*.py
%_datadir/bash-completion/completions/gdal*
%_datadir/bash-completion/completions/ogr*
%_libdir/cmake/%name/*.cmake
%_man1dir/*
%exclude %_man1dir/gdal-config.1*

%if_with docs
%files doc
%doc *.md *.txt doc/build/html
%endif

%files plugins
%_libdir/gdalplugins/drivers.ini

%files scripts
%_bindir/*.py

%files -n %libname%sover
%_libdir/*.so.%{sover}*

%files -n %libname-devel
%_bindir/gdal-config
%_libdir/*.so
%_includedir/%name
%_pkgconfigdir/gdal.pc
%_man1dir/gdal-config.1*

%files -n python3-module-%name
%python3_sitelibdir/*

%changelog
