%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define abiversion 3.0
%define socketxxsoname 1.2

%define libgdcm_common libgdcmcommon%abiversion
%define libgdcm_dict libgdcmdict%abiversion
%define libgdcm_dsed libgdcmdsed%abiversion
%define libgdcm_iod libgdcmiod%abiversion
%define libgdcm_jpeg8 libgdcmjpeg8_%abiversion
%define libgdcm_jpeg12 libgdcmjpeg12_%abiversion
%define libgdcm_jpeg16 libgdcmjpeg16_%abiversion
%define libgdcm_md5 libgdcmmd5_%abiversion
%define libgdcm_mexd libgdcmmexd%abiversion
%define libgdcm_msff libgdcmmsff%abiversion
%define libgdcm_socketxx libgdcmsocketxx%socketxxsoname
%define libgdcm_vtk libgdcmvtk%{vtk_version}_%vtk_soname

Name: gdcm
Version: 3.0.25
Release: alt1

Summary: Cross-platform DICOM implementation
License: BSD
Group: System/Libraries
Url: https://sourceforge.net/projects/gdcm/
VCS: https://git.code.sf.net/p/gdcm/gdcm.git

Source0: %name-%version.tar
Source1: gdcmData.tar
Patch0: gdcm-3.0.1-unknown-use-copyright.patch
Patch3: gdcm-3.0.24-alt-export-variables.patch

BuildRequires(pre): rpm-build-java
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-macros-vtk
BuildRequires: cmake
BuildRequires: ctest
BuildRequires: docbook5-style-xsl
BuildRequires: doxygen
BuildRequires: fontconfig-devel
BuildRequires: gcc-c++
BuildRequires: graphviz
BuildRequires: libCharLS-devel
BuildRequires: libdcmtk-devel
BuildRequires: libexpat-devel
BuildRequires: libgl2ps-devel
BuildRequires: libgraphviz
BuildRequires: libjson-c-devel
BuildRequires: libogg-devel
BuildRequires: libopenjpeg2.0-devel
BuildRequires: libpoppler-devel
BuildRequires: libsqlite3-devel
BuildRequires: libssl-devel
BuildRequires: libtheora-devel
BuildRequires: libuuid-devel
BuildRequires: libvtk-devel
BuildRequires: libxml2-devel
BuildRequires: libxslt-devel
BuildRequires: python3-devel
BuildRequires: swig
BuildRequires: xsltproc

Requires: %libgdcm_common
Requires: %libgdcm_dict
Requires: %libgdcm_dsed
Requires: %libgdcm_iod
Requires: %libgdcm_jpeg8
Requires: %libgdcm_jpeg12
Requires: %libgdcm_jpeg16
Requires: %libgdcm_md5
Requires: %libgdcm_mexd
Requires: %libgdcm_msff
Requires: %libgdcm_socketxx

%description
Grassroots DiCoM is a C++ library for DICOM medical files. It is
accessible from Python, C#, Java and PHP. It supports RAW, JPEG, JPEG
2000, JPEG-LS, RLE and deflated transfer syntax.
It comes with a super fast scanner implementation to quickly
scan hundreds of DICOM files.
It supports SCU network operations (C-ECHO, C-FIND, C-STORE, C-MOVE).
PS 3.3 & 3.6 are distributed as XML files.
It also provides PS 3.15 certificates and password based mecanism
to anonymize and de-identify DICOM datasets.

%package -n %libgdcm_common
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_common
%summary.

%package -n %libgdcm_dict
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_dict
%summary.

%package -n %libgdcm_dsed
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_dsed
%summary.

%package -n %libgdcm_iod
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_iod
%summary.

%package -n %libgdcm_jpeg8
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_jpeg8
%summary.

%package -n %libgdcm_jpeg12
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_jpeg12
%summary.

%package -n %libgdcm_jpeg16
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_jpeg16
%summary.

%package -n %libgdcm_md5
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_md5
%summary.

%package -n %libgdcm_mexd
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_mexd
%summary.

%package -n %libgdcm_msff
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_msff
%summary.

%package -n %libgdcm_socketxx
Summary: %summary
Group: System/Libraries

Conflicts: gdcm < 3.0.22

%description -n %libgdcm_socketxx
%summary.

%package -n %libgdcm_vtk
Summary: %summary
Group: System/Libraries

%description -n %libgdcm_vtk
%summary.

%package doc
Summary: Documentation for gdcm
Group: Documentation
BuildArch: noarch

%description doc
You should install the gdcm-doc package if you would like to
access upstream documentation for gdcm.

%package applications
Summary: Includes command line programs for GDCM
Group: Development/Tools

%description applications
You should install the gdcm-applications package if you would like to
use command line programs part of GDCM. Includes tools to convert,
anonymize, manipulate, concatenate, and view DICOM files.

%package devel
Summary: Libraries and headers for GDCM
Group: Development/Other

Requires: gdcm-applications

%description devel
You should install the gdcm-devel package if you would like to
compile applications based on gdcm.

%package examples
Summary: CSharp, C++, Java, PHP and Python example programs for GDCM
Group: Development/Other

%description examples
GDCM examples

%package -n python3-module-gdcm
Summary: Python binding for GDCM
Group: Development/Other

%description -n python3-module-gdcm
You should install the python3-gdcm package if you would like to
used this library with python.

%prep
%setup -a1
%autopatch -p1

sed -i \
  's/^GENERATE_LATEX.*=.*YES/GENERATE_LATEX = NO/' \
  Utilities/doxygen/doxyfile.in

rm -rf \
  Utilities/gdcmcharls \
  Utilities/gdcmexpat \
  Utilities/gdcmopenjpeg \
  Utilities/gdcmutfcpp \
  Utilities/gdcmuuid \
  Utilities/gdcmzlib \
  #

%build
%ifarch %ix86
%add_optflags -D_FILE_OFFSET_BITS=64
%endif
# vtk module require using relative path from prefix
%cmake -Wno-dev -Wno-unused-variable \
  -DCMAKE_BUILD_TYPE:STRING=Release \
  -DCMAKE_CXX_STANDARD=20 \
  -DCMAKE_INSTALL_PREFIX:PATH=%prefix \
  -DCMAKE_SKIP_RPATH:BOOL=ON \
  -DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
  -DDOCUMENTATION_DOWNLOAD_VTK_TAGFILE:BOOL=OFF \
  -DEXPAT_LIBRARY:FILEPATH=%_libdir/libexpat.so \
  -DGDCM_BUILD_APPLICATIONS:BOOL=ON \
  -DGDCM_BUILD_DOCBOOK_MANPAGES:BOOL=ON \
  -DGDCM_BUILD_EXAMPLES:BOOL=OFF \
  -DGDCM_BUILD_SHARED_LIBS:BOOL=ON \
  -DGDCM_BUILD_TESTING:BOOL=ON \
  -DGDCM_DATA_ROOT:PATH=../gdcmData \
  -DGDCM_DOCUMENTATION:BOOL=ON \
  -DGDCM_DOXYGEN_NO_FOOTER:BOOL=ON \
  -DGDCM_INSTALL_DOC_DIR:PATH=%_docdir/gdcm \
  -DGDCM_INSTALL_INCLUDE_DIR:PATH=include/gdcm \
  -DGDCM_INSTALL_LIB_DIR:PATH=%_lib \
  -DGDCM_INSTALL_MAN_DIR:PATH=%_mandir \
  -DGDCM_INSTALL_PACKAGE_DIR:PATH=%_lib/cmake/gdcm \
  -DGDCM_INSTALL_PYTHONMODULE_DIR:STRING=%_lib/python3/site-packages \
  -DGDCM_NO_PYTHON_LIBS_LINKING:BOOL=ON \
  -DGDCM_NO_VTKJAVA_LIBS_LINKING:BOOL=ON \
  -DGDCM_PDF_DOCUMENTATION:BOOL=OFF \
  -DGDCM_USE_JPEGLS:BOOL=ON \
  -DGDCM_USE_PARAVIEW:BOOL=OFF \
  -DGDCM_USE_PVRG:BOOL=ON \
  -DGDCM_USE_SYSTEM_CHARLS:BOOL=ON \
  -DGDCM_USE_SYSTEM_EXPAT:BOOL=ON \
  -DGDCM_USE_SYSTEM_JSON:BOOL=ON \
  -DGDCM_USE_SYSTEM_LIBXML2:BOOL=ON \
  -DGDCM_USE_SYSTEM_OPENJPEG:BOOL=ON \
  -DGDCM_USE_SYSTEM_OPENSSL:BOOL=ON \
  -DGDCM_USE_SYSTEM_POPPLER:BOOL=ON \
  -DGDCM_USE_SYSTEM_UUID:BOOL=ON \
  -DGDCM_USE_SYSTEM_ZLIB:BOOL=ON \
  -DGDCM_USE_VTK:BOOL=ON \
  -DGDCM_VTK_DOCUMENTATION:BOOL=OFF \
  -DGDCM_WRAP_CSHARP:BOOL=OFF \
  -DGDCM_WRAP_JAVA:BOOL=OFF \
  -DGDCM_WRAP_PHP:BOOL=OFF \
  -DGDCM_WRAP_PYTHON:BOOL=ON \
  -DJAVA_HOME:PATH=%_jvmdir/java \
  -DPYTHON_EXECUTABLE:PATH=%_bindir/python3 \
  -DPYTHON_VERSION_MAJOR=3 \
  -DVTKGDCM_WRAP_JAVA:BOOL=OFF \
  -DVTKGDCM_WRAP_PYTHON:BOOL=ON \
  #

%cmake_build

%install
%cmake_install
install -d \
  %buildroot%python3_sitelibdir \
  %buildroot%_datadir/%name/Examples \
  %buildroot%_includedir/%name \
  #
install -Dm 644 Utilities/gdcm_zlib.h \
  -t %buildroot%_includedir

cp -rv Examples/* %buildroot%_datadir/%name/Examples

%check
export LD_LIBRARY_PATH="%buildroot%_libdir"
export PYTHONPATH="%buildroot%python3_sitelibdir"
%ctest ||:

%files

%files -n %libgdcm_common
%doc AUTHORS README.md
%_libdir/libgdcmCommon.so.%{abiversion}*

%files -n %libgdcm_dsed
%_libdir/libgdcmDSED.so.%{abiversion}*

%files -n %libgdcm_dict
%_libdir/libgdcmDICT.so.%{abiversion}*

%files -n %libgdcm_iod
%_libdir/libgdcmIOD.so.%{abiversion}*

%files -n %libgdcm_jpeg8
%_libdir/libgdcmjpeg8.so.%{abiversion}*

%files -n %libgdcm_jpeg12
%_libdir/libgdcmjpeg12.so.%{abiversion}*

%files -n %libgdcm_jpeg16
%_libdir/libgdcmjpeg16.so.%{abiversion}*

%files -n %libgdcm_md5
%_libdir/libgdcmmd5.so.%{abiversion}*

%files -n %libgdcm_mexd
%_libdir/libgdcmMEXD.so.%{abiversion}*

%files -n %libgdcm_msff
%_libdir/libgdcmMSFF.so.%{abiversion}*

%files -n %libgdcm_socketxx
%_libdir/libsocketxx.so.%{socketxxsoname}*

%files -n %libgdcm_vtk
%_libdir/libvtkgdcm-%vtk_version.so.*

%files doc
%_docdir/gdcm/html

%files applications
%_bindir/gdcm*
%_man1dir/gdcm*

%files devel
%_datadir/gdcm-*/XML/
%_includedir/gdcm/
%_includedir/gdcm_zlib.h
%_includedir/vtkgdcmpython.h
%_libdir/cmake/gdcm/
%_libdir/lib*.so
%_libdir/vtk-%vtk_version/hierarchy/vtkgdcm/vtkgdcm-hierarchy.txt

%files examples
%_datadir/gdcm/Examples

%files -n python3-module-gdcm
%python3_sitelibdir/gdcm.py
%python3_sitelibdir/gdcmswig.py
%python3_sitelibdir/_gdcmswig.so
%python3_sitelibdir/__pycache__/
%python3_sitelibdir/vtkgdcm/

%changelog
