%define _unpackaged_files_terminate_build 1

Summary: Gearman provides a generic application framework to farm out work to other machines.
Name: gearmand
Version: 1.1.21
Release: alt1
License: BSD
Group: Development/C
URL: https://gearman.org/

VCS: https://github.com/gearman/gearmand.git
Source: %name-%version.tar

BuildRequires: perl gcc-c++ boost-devel boost-program_options-devel libevent-devel libuuid-devel gperf
BuildRequires: libsqlite3-devel libtokyocabinet-devel libmemcached-devel memcached libhiredis-devel
BuildRequires: mysql-devel postgresql-devel zlib-devel
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink python3-module-sphinx_rtd_theme
BuildRequires: libssl-devel

%description
%summary

%package devel
Summary:        Gearmand development files
Group:          Development/C++
Requires:       %name = %EVR

%description devel
This package contains necessary header files for Gearman development.

%prep
%setup
# provide information about version needed for bootstrap
sed -i -e 's:git describe --always:echo %version:' \
	version.m4 \
	configure.ac

%build
# without following export it fails to build with new boost for some reason on ppc64le
export ax_boost_user_program_options_lib=boost_program_options
%autoreconf
%configure \
	--enable-ssl \
	--disable-static \
	--localstatedir=%_var \
	%nil

# first build docs
pushd docs
%make_build
popd

%make_build

%install
%makeinstall_std

%files
%doc ChangeLog README.md COPYING
%_bindir/gearman
%_bindir/gearadmin
%_libdir/libgearman.so.*
%_sbindir/gearmand
%_man1dir/*
%_man8dir/*

%files devel
%_includedir/libgearman/*
%_includedir/libgearman-1.0/*
%_libdir/libgearman.so
%_pkgconfigdir/gearmand.pc
%_man3dir/*

%changelog
