%def_enable snapshot
%set_verify_elf_method unresolved=relaxed
%define xdg_name org.gnome.gedit
%define _libexecdir %_prefix/libexec

%define ver_major 48
%define beta %nil
%define lib_ver 48.2
%define api_ver 3.0
%define namespace Gedit
%def_enable plugins
%def_enable introspection
%def_enable gtk_doc

Name: gedit
Version: %ver_major.2
Release: alt1%beta

Summary: gEdit is a small but powerful text editor for GNOME
License: GPL-2.0-or-later and GPL-3.0-or-later and LGPL-3.0-or-later
Group: Editors
Url: https://gedit-text-editor.org

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%endif

%define pkglibdir %_libdir/%name
%define pkgdatadir %_datadir/%name
%set_typelibdir %pkglibdir
%set_girdir %pkgdatadir

%define glib_ver 2.76.0
%define gtk_ver 3.24.0
%define tepl_ver 6.11
%define gtksourceview_ver 299.3.0
%define peas_ver 1.14.1
%define gspell_ver 1.0.0
%define soup_ver 2.60.0

#Obsoletes: %name-plugins < 48.2
#Provides: %name-plugins = %EVR

Requires: %name-data = %EVR
Requires: %name-gir = %EVR
Requires: typelib(Peas) = 1.0 typelib(Gdk) = 3.0
Requires: dconf gnome-icon-theme gvfs zenity

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-build-gir
BuildRequires: meson yelp-tools %_bindir/appstream-util
BuildRequires: desktop-file-utils >= 0.22
BuildRequires: gtk-doc >= 1.0
BuildRequires: iso-codes-devel >= 0.35
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(libgedit-amtk-5)
BuildRequires: pkgconfig(libgedit-tepl-6) >= %tepl_ver
BuildRequires: libpeas-devel >= %peas_ver
BuildRequires: libgedit-gtksourceview-devel >= %gtksourceview_ver
BuildRequires: libgspell-devel >= %gspell_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: libattr-devel libxml2-devel gsettings-desktop-schemas-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.10.2 libgtk+3-gir-devel
BuildRequires: libgedit-gtksourceview-gir-devel libgedit-tepl-gir-devel}

%description
gEdit is the official text editor of the GNOME desktop environment.

While aiming at simplicity and ease of use, gedit is a powerful general
purpose text editor which features full support for UTF-8, configurable
highlighting for various languages and many other features making it a
great editor for advanced tasks.

%package data
Summary: Arch independent files for gEdit
Group: Editors
BuildArch: noarch

%description data
This package provides noarch data needed for gEdit to work.

%package devel
Group: Development/C
Summary: Libraries needed to develop plugins for gedit
Requires: %name = %EVR

%description devel
Libraries needed to develop plugins for gedit.

%package gir
Summary: GObject introspection data for the Gedit
Group: System/Libraries
Requires: %name = %EVR
Requires: libgedit-tepl-gir >= %tepl_ver

%description gir
GObject introspection data for the Gedit

%package gir-devel
Summary: GObject introspection devel data for the Gedit
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the Gedit

%package devel-doc
Group: Development/C
Summary: Development documentation for gedit
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
This package contains documentation needed to develop plugins for gedit.


%prep
%setup -n %name-%version%beta

%build
%meson \
    -Dbuildtype=plain \
    %{subst_enable_meson_bool gtk_doc gtk_doc}
%nil
%meson_build

%install
%meson_install

ln -sf %name/lib%name-%lib_ver.so \
%buildroot%_libdir/lib%name-%lib_ver.so

# additional mime types
desktop-file-install --dir %buildroot%_desktopdir \
	--add-mime-type=text/css \
	--add-mime-type=text/csv \
	--add-mime-type=text/english \
	--add-mime-type=text/plain \
	--add-mime-type=text/tab-separated-values \
	--add-mime-type=text/x-adasrc \
	--add-mime-type=text/x-bibtex \
	--add-mime-type=text/x-c++ \
	--add-mime-type=text/x-chdr \
	--add-mime-type=text/x-c++hdr \
	--add-mime-type=text/x-csharp \
	--add-mime-type=text/x-csrc \
	--add-mime-type=text/x-c++src \
	--add-mime-type=text/x-dsrc \
	--add-mime-type=text/x-fortran \
	--add-mime-type=text/x-gle \
	--add-mime-type=text/x-java \
	--add-mime-type=text/x-javascript \
	--add-mime-type=text/x-log \
	--add-mime-type=text/x-makefile \
	--add-mime-type=text/x-objcsrc \
	--add-mime-type=text/x-pascal \
	--add-mime-type=text/x-patch \
	--add-mime-type=text/x-perl \
	--add-mime-type=text/x-php \
	--add-mime-type=text/x-python \
	--add-mime-type=text/x-sql \
	--add-mime-type=text/x-sh \
	--add-mime-type=text/x-tcl \
	--add-mime-type=text/x-tex \
	%buildroot%_desktopdir/%xdg_name.desktop

%find_lang --with-gnome %name

%files
%_bindir/*
%dir %pkglibdir
%pkglibdir/lib%{name}*.so
#symlink
%_libdir/lib%name-%lib_ver.so
%dir %gedit_pluginsdir
%gedit_pluginsdir/*

%files data -f %name.lang
%pkgdatadir/
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/org.gnome.gedit.service
%_mandir/man?/*
%config %_datadir/glib-2.0/schemas/*
%_iconsdir/hicolor/*/apps/%xdg_name.png
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* NEWS

%exclude %pkgdatadir/gir-1.0/

%files devel
%_includedir/*
%_pkgconfigdir/*

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%name
%endif

%if_enabled introspection
%files gir
%pkglibdir/girepository-1.0/%namespace-%api_ver.typelib
%files gir-devel
%pkgdatadir/gir-1.0/%namespace-%api_ver.gir
%endif

%changelog
