%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define rdn_name org.geeqie.Geeqie

%def_enable map
%def_enable ffmpegthumbnailer
%def_enable lua
%def_disable check

Name: geeqie
Version: 2.5
Release: alt1

Summary: Graphics file browser utility
License: GPL-2.0-or-later
Group: Graphics
Url: https://www.%name.org

%if_disabled snapshot
Source: https://github.com/BestImageViewer/geeqie/archive/v%version/%name-%version.tar.gz
%else
Vcs: https://github.com/BestImageViewer/geeqie.git
Source: %name-%version.tar
%endif

# https://bugzilla.altlinux.org/49370
#Provides: gqview = %EVR
#Obsoletes: gqview < %version

%define lua_ver 5.3

%{?_enable_lua:Requires: lua%lua_ver}
Requires: %_bindir/exiftool %_bindir/exiftran
Requires: %_bindir/convert %_bindir/gphoto2
Requires: %_bindir/zenity lcms2-utils >= 2.12-alt2
Requires: libwebp-pixbuf-loader
# for print preview
Requires: evince

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ yelp-tools /usr/bin/appstream-util
BuildRequires: evince
BuildRequires: python3-module-markdown pandoc
BuildRequires: libgtk+3-devel libjpeg-devel libtiff-devel libwebp-devel
BuildRequires: libopenjpeg2.0-devel libdjvu-devel liblcms2-devel
BuildRequires: libwebp-pixbuf-loader
%ifnarch armh
BuildRequires: libjxl-devel
%endif
BuildRequires: libpoppler-glib-devel libheif-devel
BuildRequires: libraw-devel libgomp-devel
BuildRequires: libexiv2-devel zlib-devel libarchive-devel
BuildRequires: libgspell-devel
%{?_enable_lua:BuildRequires: liblua%lua_ver-devel}
%{?_enable_map:BuildRequires: libgps-devel pkgconfig(clutter-gtk-1.0) libchamplain-gtk3-devel}
%{?_enable_ffmpegthumbnailer:BuildRequires: libffmpegthumbnailer-devel}
%{?_enable_check:BuildRequires: xvfb-run shellcheck}

%description
Geeqie is a lightweight image viewer. It was forked from GQview. The development
is focused on features for photo collection maintenance: raw format, Exif/IPTC/XMP
metadata and integration with programs like UFraw, ImageMagick, Gimp, gPhoto or
ExifTool.

%prep
%setup

%build
%{?_enable_ffmpegthumbnailer:%add_optflags -Wno-error=unused-function}

%meson \
    -Dgq_bindir='%_lib/%name' \
    -Dgq_helpdir='share/%name' \
    %{?_disable_ffmpegthumbnailer:-Dvideothumbnailer=disabled} \
    %{?_disable_lua:-Dlua=disabled} \
    %{?_disable_map:-Dmap=disabled}
%nil
%meson_build

%install
%meson_install
install -pD -m644 %name.png %buildroot%_liconsdir/%name.png

%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%dir %_libdir/%name
%_libdir/%name/%name-camera-import
%_libdir/%name/%name-camera-import-hook-script
%_libdir/%name/%name-exif-datetime-to-file
%_libdir/%name/%name-export-jpeg
%_libdir/%name/%name-image-crop
%_libdir/%name/%name-random-image
%_libdir/%name/%name-resize-image
%_libdir/%name/%name-rotate
%_libdir/%name/%name-symlink
%_libdir/%name/%name-tethered-photography
%_libdir/%name/%name-tethered-photography-hook-script
%_libdir/%name/downsize
%_libdir/%name/geocode-parameters.awk
%_libdir/%name/lensID
%_libdir/%name/resize-help.sh
%_desktopdir/%rdn_name.desktop
%_pixmapsdir/%name.png
%_iconsdir/hicolor/*x*/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_man1dir/%name.1.*
%_datadir/metainfo/%rdn_name.appdata.xml
%_datadir/bash-completion/completions/%name
%doc NEWS README.*

%changelog
