# llvm needs for unregisterised architectures
%ifarch armh aarch64
%define _llvm_version 12.0
%endif

%def_without bootstrap

%define ghc_version 9.0.2
%define ghc_major 9.0
%define _ghclibdir %_libdir/ghc-%version

%def_with docs

Name: ghc%ghc_major
Version: %ghc_version
Release: alt2

Summary: Glasgow Haskell Compilation system
License: BSD-3-Clause and HaskellReport
Group: Development/Haskell
Url: http://haskell.org/ghc/

Source: %name-%version.tar
Source1: ghc.macros
Source10: get_libs_versions.sh

# Patches from 10 to 20 is for doc generation
# Order is important
Patch10: ghc9.0-backport-sphinx_changes.patch
Patch11: ghc9.0-backport-extlinks_modern_syntax.patch
Patch12: ghc9.0-backport-distutils_replace.patch
Patch13: ghc9.0-suse-sphinx7.patch

Patch20: ghc9.0-debian-no_missing_haddock_file_warning.patch

Requires: libffi-devel libgmp-devel

# <https://bugzilla.altlinux.org/show_bug.cgi?id=31576>:
Requires: glibc-gconv-modules

# The installed Haskell libs will be processed:
Requires(pre,postun): haskell-filetrigger

# For ghc-pkg with rpath running during install, see:
# https://www.altlinux.org/Hasher/FAQ
# https://lists.altlinux.org/pipermail/devel/2018-April/204171.html
# Not needed after rebuild with separate single directory for shared libraries
BuildRequires: /proc

# Bootstrap with the previous version
%if_with bootstrap
    %define build_ghc_major 8.10.7
%else
    %define build_ghc_major 9.0
%endif

BuildRequires: ghc%build_ghc_major-devel
BuildRequires: ghc%build_ghc_major-common

# Macroses needed for libs subpackages
# (Pre) here to remove annoying warnings
BuildRequires(Pre): rpm-build-haskell-extra

BuildRequires: binutils-devel docbook-dtds docbook-style-xsl libelf-devel libffi-devel libgmp-devel libncurses-devel xsltproc

# Needs for build man
BuildRequires: python3-module-sphinx-sphinx-build-symlink

Provides: haskell(abi) = %version

%ifarch armh aarch64
BuildRequires: rpm-macros-llvm-common
BuildRequires: llvm%{?_llvm_version}
Requires: llvm%{?_llvm_version}
%endif

%description
Haskell is a standard lazy functional programming language; the
current language version is Haskell 98, agreed in December 1998.

GHC is a state-of-the-art programming suite for Haskell.  Included is
an optimising compiler generating good code for a variety of
platforms, together with an interactive system for convenient, quick
development.  The distribution includes space and time profiling
facilities, a large collection of libraries, and support for various
language extensions, including concurrency, exceptions, and foreign
language interfaces (C, C++, whatever).

A wide variety of Haskell related resources (tutorials, libraries,
specifications, documentation, compilers, interpreters, references,
contact information, links to research groups) are available from the
Haskell home page at <http://www.haskell.org/>.

%package common
BuildArch: noarch
Summary: Selects the default version of Glasgow Haskell Compilation system
Group: Development/Haskell

Requires: %name = %EVR
Requires: rpm-macros-%{name}-common = %EVR

%description common
Install this package to select %version as the default version
of Glasgow Haskell Compiler.

It will make rpm-build-haskell use this version of GHC for
building other Haskell packages
(if their .spec refers to %%ghc_version and %%_ghclibdir).

%package -n rpm-macros-%{name}-common
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/Other

BuildArch: noarch

Provides: rpm-macros-ghc-common = %EVR
Conflicts: rpm-macros-ghc-common < %EVR
Conflicts: rpm-macros-ghc-common > %EVR

%description -n rpm-macros-%{name}-common
Set of RPM macros for packaging %name-based applications for ALT Linux.
Install this package if you want to create RPM packages that use %name.

%package doc
Summary: Documentation for GHC
Group: Development/Haskell

%description doc
Preformatted documentation for the Glasgow Haskell Compiler
(GHC) and its libraries. Install it if you like to have local
access to the documentation in PostScript and HTML format.
Alternatively, the documentation is available online at
http://haskell.org/ghc/documentation.html

%package doc-index
Summary: GHC library documentation indexing
Group: Development/Haskell

BuildArch: noarch

%description doc-index
The package enables re-indexing of installed library documention.

# Generated by get_libs_subpackages.sh
# Each standart library separated to subpackages (devel and runtime)
%define basepkg_version 4.15.1.0
%ghc_lib_subpackage -n base -v %basepkg_version
%ghc_lib_subpackage -n array -v 0.5.4.0
%ghc_lib_subpackage -n binary -v 0.8.8.0
%ghc_lib_subpackage -n bytestring -v 0.10.12.1
%ghc_lib_subpackage -n Cabal -v 3.4.1.0
%ghc_lib_subpackage -n containers -v 0.6.4.1
%ghc_lib_subpackage -n deepseq -v 1.4.5.0
%ghc_lib_subpackage -n directory -v 1.3.6.2
%ghc_lib_subpackage -n exceptions -v 0.10.4
%ghc_lib_subpackage -n filepath -v 1.4.2.1
%ghc_lib_subpackage -n ghc-bignum -v 1.1
%ghc_lib_subpackage -n ghc-boot -v 9.0.2
%ghc_lib_subpackage -n ghc-boot-th -v 9.0.2
%ghc_lib_subpackage -n ghc-compact -v 0.1.0.0
%ghc_lib_subpackage -n ghc-heap -v 9.0.2
%ghc_lib_subpackage -n ghc-prim -v 0.7.0
%ghc_lib_subpackage -n haskeline -v 0.8.2
%ghc_lib_subpackage -n hpc -v 0.6.1.0
%ghc_lib_subpackage -n integer-gmp -v 1.1
%ghc_lib_subpackage -n libiserv -v 9.0.2
%ghc_lib_subpackage -n mtl -v 2.2.2
%ghc_lib_subpackage -n parsec -v 3.1.14.0
%ghc_lib_subpackage -n pretty -v 1.1.3.6
%ghc_lib_subpackage -n process -v 1.6.13.2
%ghc_lib_subpackage -n stm -v 2.5.0.0
%ghc_lib_subpackage -n template-haskell -v 2.17.0.0
%ghc_lib_subpackage -n terminfo -v 0.4.1.5
%ghc_lib_subpackage -n text -v 1.2.5.0
%ghc_lib_subpackage -n time -v 1.9.3
%ghc_lib_subpackage -n transformers -v 0.5.6.2
%ghc_lib_subpackage -n unix -v 2.7.2.2
%ghc_lib_subpackage -n xhtml -v 3000.2.2.1

# Added manually
%ghc_lib_subpackage -n ghc -v %ghc_version
%ghc_lib_subpackage -n ghci -v %ghc_version

%package devel
Summary: GHC development libraries meta package
Version: %ghc_version
Group: Development/Haskell

Requires: %name = %EVR
Requires: %name-common = %EVR
Requires: %ghc_devel_subpackages_list

%description devel
This is a meta-package for all the development library packages in GHC

%prep
%setup

%ifarch aarch64
    echo "BuildFlavour = perf-llvm" >> mk/build.mk
%else
    echo "BuildFlavour = perf" >> mk/build.mk
%endif

%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1

%patch20 -p1

%build
#Set target x86_64-unknown-linux
%define _configure_target %nil

# Fixed internal error in haddock (see git log for details)
export LANG=en_US.UTF-8

./boot
%configure --with-system-libffi --disable-unregisterised
%make_build V=1

%install
%define docdir %_docdir/ghc-%version
%makeinstall_std docdir=%docdir
mv %buildroot%docdir/html/* %buildroot%docdir/
rmdir %buildroot%docdir/html

# generate fake .pkg configs for core packages.
# haskell.prov will convert them to package provides.
for lib in %buildroot%_libdir/ghc-%version/*-[0-9]*; do
       namever="$(basename "$lib")"
       name="${namever%%-*}"
       echo -e "name: $name\nversion: ${namever##*-}" >"$lib/$name.pkg"
done
cp -a LICENSE README.md %buildroot%docdir/

# generate the file list for lib/ _excluding_ all files needed for profiling
# only
#
# * generating file lists in a BUILD_ROOT spec is a bit tricky: the file list
#   has to contain complete paths, _but_ without the BUILD_ROOT, we also do
#   _not_ want to have directory names in the list; furthermore, we have to make
#   sure that any leading / is removed from %%_libdir, as find has to
#   interpret the argument as a relative path; however, we have to include the
#   leading / again in the final file list (otherwise, rpm complains)
# * isn't there an easier way to do all this?
{
pushd %buildroot >/dev/null
find .%_libdir ! -type d ! -name 'package.conf*' \
     -print | sed 's|^\.||'
find .%_libdir -type d -print | sed 's|^\.|%%dir |'
popd >/dev/null
} > rpm-files

# touch our "ghost". ghc-pkg may create him later.
touch %buildroot%_libdir/ghc-%version/package.conf.old
# package-provided *.confs go in this directory:
mkdir -p %buildroot%_libdir/ghc-%version/package.conf.d

# generate separate single directory for core dynamic libraries
mkdir -p %buildroot%_libdir/ghc-%version/lib
for so in %buildroot%_libdir/ghc-%version/*/*-ghc%version.so; do
       relpath="$(relative "$so" "%buildroot%_libdir/ghc-%version/lib/")"
       ln -s "$relpath" %buildroot%_libdir/ghc-%version/lib/
done

mkdir -p %buildroot%_sysconfdir/ld.so.conf.d
echo "%_libdir/ghc-%version/lib" >%buildroot%_sysconfdir/ld.so.conf.d/ghc-%version.conf

# need for multiple ghc versions installed
for s in hp2ps hpc hsc2hs; do
    mv %buildroot%_bindir/"$s" %buildroot%_bindir/"$s"-%version
    ln -s "$s"-%version %buildroot%_bindir/"$s"
done

# Check the correctness of our packaging:
# all unversioned executables must be symlinks:
for s in %buildroot%_bindir/*; do
    case "$s" in
    *-%{version}) :
    ;;
    *) test -L "$s"
    ;;
    esac
done

mv %buildroot%_man1dir/ghc.1 %buildroot%_man1dir/%name.1

sed -i 's!/html/!/!' %buildroot%_libdir/ghc-%version/package.conf.d/*.conf

# Generate file lists for all subpackages
# expands to %%ghc_gen_filelist {NAME} {VERSION} for each package
# SOURCE10 means get_libs_versions.sh
%SOURCE10 | xargs -n 2 %ghc_gen_filelist
%ghc_gen_filelist ghc %version
%ghc_gen_filelist ghci %version

# Adding rts lib to base package
echo "%_ghclibdir/include" >> base-%basepkg_version-files.devel
echo "%_ghclibdir/package.conf.d/rts.conf" >> base-%basepkg_version-files.devel

find "%buildroot%_ghclibdir" \( -name "*rts*.so" -a -not -name "*debug*" \) \
                | sed "s|%buildroot||g" >> base-%basepkg_version-files.runtime
find "%buildroot%_ghclibdir" \( -name "*rts*.so" -a -name "*debug*" \) \
                | sed "s|%buildroot||g" >> base-%basepkg_version-files.devel

find "%buildroot%_ghclibdir" \( -name "*rts*.a" \) \
                | sed "s|%buildroot||g" >> base-%basepkg_version-files.devel

echo "%%dir %_ghclibdir/rts" >> base-%basepkg_version-files.runtime

# install and fix up the macros file
mkdir -p %buildroot%_rpmmacrosdir
install %SOURCE1 %buildroot%_rpmmacrosdir/ghc
sed -i 's/@GHC_VERSION@/%version/' %buildroot%_rpmmacrosdir/ghc

%files
%_ghclibdir/bin/
%_bindir/*-%version
%dir %_libdir/ghc-%version
%dir %docdir/
%_bindir/*-%version
%_man1dir/%name.1*
%ghost %_ghclibdir/package.conf.old
%dir %_ghclibdir/package.conf.d
%dir %_ghclibdir/lib
%_ghclibdir/package.conf.d/package.cache*
%_ghclibdir/platformConstants
%_ghclibdir/settings
%_ghclibdir/template-hsc.h
%_ghclibdir/ghc-usage.txt
%_ghclibdir/ghci-usage.txt
%_ghclibdir/llvm-passes
%_ghclibdir/llvm-targets
%_ghclibdir/html
%_ghclibdir/latex
%_sysconfdir/ld.so.conf.d/ghc-%version.conf
%docdir/LICENSE
%docdir/README.md

%files common
%_bindir/*
%exclude %_bindir/*-%version

%files -n rpm-macros-%{name}-common
%_rpmmacrosdir/*

%files doc-index
%dir %docdir/libraries
%docdir/libraries/*.html
%docdir/libraries/*.js
%docdir/libraries/*.css
%docdir/libraries/*.txt
%docdir/libraries/*.png
%docdir/libraries/gen_contents_index

%files doc
%dir %docdir
%docdir/users_guide
%docdir/haddock
%docdir/index.html

%files devel

%changelog
