%define origname ghostscript
Name: ghostscript9
Version: 9.56.1
Release: alt1

%define ijsver	0.35
%global origver %version
%define esp_name esp-ghostscript
%define gnu_name gnu-ghostscript

Url: http://www.ghostscript.com

License: GPLv3+

Summary: PostScript interpreter and renderer, most printer drivers
Group: Publishing

Source: ghostpdl-%version.tar.gz
Source1: repatch_spec.sh
Source2: ghostscript.unused
Source3: README.patches

## FC patches
Patch0: FC-9.56-fix-PDFFitPage-with-square-MediaBox.patch
Patch1: FC-9.56.1-Fix-color-info-juggling-with-x11-devices.patch
Patch2: FC-9.56.1-use-proper-bounds-check-for-subfunctions-of.patch
Patch3: FC-9.56.1-Deal-with-different-VM-modes-during-CIDFont-loading.patch

## Ubuntu patches
Patch101: Ubuntu-2001_docdir_fix_for_debian.patch
Patch102: Ubuntu-2002_gs_man_fix_debian.patch
Patch103: Ubuntu-2003_support_multiarch.patch
Patch104: Ubuntu-2004_remove_non-Debian_paths_from_docs.patch
Patch105: Ubuntu-2005_fix_Debian_paths_in_docs.patch
Patch106: Ubuntu-2006_suggest_install_ghostscript-doc_in_docs.patch
Patch107: Ubuntu-2007_suggest_install_ghostscript-doc_in_code.patch
Patch108: Ubuntu-2008_mention_ghostscript-x_in_docs.patch
Patch109: Ubuntu-2009_use_system_javascript.patch
Patch110: Ubuntu-2010_add_build_timestamp_setting.patch
Patch111: Ubuntu-2011_avoid_remote_font.patch
Patch112: Ubuntu-2012_avoid_googletagmanager.patch
Patch113: Ubuntu-CVE-2020-15900.patch

## ALT patches
Patch500: ghostscript-alt-ijs-version.patch
Patch501: alt-urw-fonts-naming.patch
Patch502: ghostscript-9.23-100-run-dvipdf-securely.patch
Patch600: CVE-2021-3781.patch

# Eliminate libpng12-devel
# Automatically added by buildreq on Thu Apr 13 2023
# optimized out: fontconfig-devel glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libfreetype-devel libgpg-error libpng-devel perl pkg-config python3 python3-base sh4 zlib-devel
BuildRequires: libcups-devel libjpeg-devel libopenjpeg2.0-devel libpaper-devel libtiff-devel

BuildRequires: libpng-devel libfreetype-devel

%package -n libgs9
Summary: Shared library for %name
Group: Publishing
Provides: %esp_name-lib = %version, %gnu_name-lib = %version, %name-lib = %version
Obsoletes: %gnu_name-lib, %esp_name-lib, %name-lib

%package common
Version: %origver
Summary: Common files for the %name
Group: Publishing
Requires: urw-fonts >= 1.1
Provides: %esp_name-common = %version, %gnu_name-common = %version
Obsoletes: %gnu_name-common, %esp_name-common
BuildArch: noarch

%description
Ghostscript is a set of software that provides a PostScript(TM) interpreter,
a set of C procedures (the Ghostscript library, which implements the
graphics capabilities in the PostScript language) and an interpreter for
Portable Document Format (PDF) files. Ghostscript translates PostScript code
into many common, bitmapped formats, like those understood by your printer
or screen. Ghostscript is normally used to display PostScript files and to
print PostScript files to non-PostScript printers.
Most applications use PostScript for printer output.

In addition, the package contains filters which transfer the raw
bitmap of GhostScript into the protocol of some additional printer
models.

You should install ghostscript if you need to display PostScript files, or
if you have a non-PostScript printer.

%description -n libgs9
Shared library for %name

%description common
Common files for the %name

%prep
%setup -n ghostpdl-%version

rm -rf expat freetype icclib jasper jpeg lcms lcms2 libpng openjpeg zlib cups/libs

## FC apply patches
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

## Ubuntu apply patches
%patch101 -p1
#patch102 -p1
#patch103 -p1
%patch104 -p1
#patch105 -p1
#patch106 -p1
#patch107 -p1
#patch108 -p1
#patch109 -p1
%patch110 -p1
#patch111 -p1
#patch112 -p1
#patch113 -p1

## ALT apply patches
%patch500 -p1
%patch501 -p1
%patch502 -p1
#patch600 -p1

sed -i 's/FT_CALLBACK_DEF(\(.*\))/static \1/g' base/fapi_ft.c
sed -i 's/ -dNO/ -dNOSAFER -dNO/' lib/pfbtopfa

%build
export CFLAGS=-DA4
%autoreconf

%configure --enable-dynamic \
	   --disable-gpdl \
	   --with-system-libtiff \
           --without-ijs \
	   --with-drivers=ALL \
	   --disable-compile-inits \
           --without-x \
           --without-pcl \
           --without-xps \
           --without-gpdl \
           --disable-gtk \
	   --with-fontpath=/usr/share/fonts/default:\
/usr/share/fonts/type1:\
/usr/share/fonts/type1/urw:\
/usr/share/fonts:\
%_datadir/ghostscript/conf.d \

%make_build so \
	prefix=%prefix \
	mandir=%_mandir \
	datadir=%_datadir \
	gsincludedir=%_includedir/ghostscript/ \
	bindir=%_bindir \
	libdir=%_libdir \
	docdir=%_defaultdocdir/%origname-%version \
	gsdir=%_datadir/%origname \
	gsdatadir=%_datadir/%origname/%version \
	gssharedir=%_libdir/%origname/%version \

%install
make soinstall \
	prefix=$RPM_BUILD_ROOT%prefix \
	mandir=$RPM_BUILD_ROOT%_mandir \
	datadir=$RPM_BUILD_ROOT%_datadir \
	gsincludedir=$RPM_BUILD_ROOT%_includedir/ghostscript/ \
	bindir=$RPM_BUILD_ROOT%_bindir \
	libdir=$RPM_BUILD_ROOT%_libdir \
	docdir=$RPM_BUILD_ROOT%_defaultdocdir/%origname-%version \
	gsdir=$RPM_BUILD_ROOT%_datadir/%origname \
	gsdatadir=$RPM_BUILD_ROOT%_datadir/%origname/%version \
	gssharedir=$RPM_BUILD_ROOT%_libdir/%origname/%version \


# XXX upstream soinstall is incomplete!
# cp -ap sobin/lib* %buildroot%_libdir/
# for N in sobin/g*c; do T="`basename $N`"; T="${T%%c}"; install $N %buildroot%_bindir/$T; done

# XXX upstream soinstall junk
# rm %buildroot%_bindir/gsc

# rm -rf -- %buildroot%_mandir/de
# rm -rf -- %buildroot%_datadir/ghostscript/%version/Resource/Font
# rm -f  -- %buildroot%_bindir/ijs_{client,server}_example

mkdir -p %buildroot/%_datadir/ghostscript/conf.d

%files common
%_datadir/ghostscript
%_datadir/ghostscript/conf.d

%files -n libgs9
%_libdir/lib*.so.*
%exclude %_mandir
%exclude %_defaultdocdir/*
%exclude %_bindir/*
%exclude %_includedir
%exclude %_libdir/*.so
%exclude %_libdir/ghostscript

%changelog
