%define _unpackaged_files_terminate_build 1
%def_enable snapshot
%define modname gidocgen
%define ver_major 2025
%def_disable flake8_test

%def_enable check

Name: gi-docgen
Version: %ver_major.3
Release: alt2

Summary: Documentation tool for GObject-based libraries
Group: Development/Other
License: Apache-2.0 or GPL-3.0-or-later
Url: https://pypi.org/project/gi-docgen/

Vcs: https://gitlab.gnome.org/GNOME/gi-docgen.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
#Source: https://pypi.io/packages/source/g/%name/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

BuildArch: noarch

Requires: python3 >= 3.6
Requires: %name-templates = %EVR
#config.py:
Requires: python3-module-toml

BuildRequires(pre): meson rpm-build-python3
BuildRequires: python3-module-jinja2
BuildRequires: python3-module-markdown
BuildRequires: python3-module-markupsafe
BuildRequires: python3-module-Pygments
BuildRequires: python3-module-packaging
BuildRequires: python3-module-toml
BuildRequires: python3-module-typogrify
%{?_enable_check:BuildRequires: python3-module-pytest python3-module-mypy
BuildRequires: python3-module-markdown python3-module-jinja2 python3-module-Pygments
BuildRequires: python3-module-toml python3-module-typogrify
%{?_enable_flake8_test:BuildRequires: python3-module-flake8}}

%description
GI-DocGen is a document generator for GObject-based libraries. GObject is
the base type system of the GNOME project. GI-Docgen reuses the
introspection data generated by GObject-based libraries to generate the API
reference of these libraries, as well as other ancillary documentation.

%package templates
Summary: Templates for GI-DocGen
Group: Development/Other
License: Apache-2.0 or GPL-3.0-or-later and OFL-1.1

%description templates
This package provides basic template data for GI-DocGen.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

# move templates to %_datadir
mkdir -p %buildroot%_datadir/%modname
mv %buildroot%python3_sitelibdir_noarch/%modname/templates %buildroot%_datadir/%modname/
ln -sf ../../../../share/%modname/templates %buildroot%python3_sitelibdir_noarch/%modname/templates

%check
%__meson_test

%files
%_bindir/%name
%python3_sitelibdir_noarch/%modname/
%_datadir/pkgconfig/%name.pc
%doc README.md

%files templates
%dir %_datadir/%modname
%_datadir/%modname/templates/

%changelog
