%define kernel_base_version 6.6
%define kernel_source kernel-source-%kernel_base_version

Name: glibc-kernheaders
Version: %kernel_base_version
Release: alt1

Summary: Linux kernel C header files for use by glibc and other userspace software
# git grep -Fh SPDX-License-Identifier: include/uapi arch/*/include/uapi |sed 's/\*\// &/' |tr -s ' '|sort |uniq -c |sort -n
#   1 /* SPDX-License-Identifier: ((GPL-2.0 WITH Linux-syscall-note) AND MIT) */
#   1 /* SPDX-License-Identifier: ((GPL-2.0+ WITH Linux-syscall-note) OR MIT) */
#   1 /* SPDX-License-Identifier: (GPL-2.0 WITH Linux-syscall-note) OR BSD-3-Clause */
#   1 /* SPDX-License-Identifier: (GPL-2.0 WITH Linux-syscall-note) OR Linux-OpenIB */
#   1 /* SPDX-License-Identifier: (GPL-2.0 WITH Linux-syscall-note) or BSD-3-Clause */
#   2 /* SPDX-License-Identifier: ((GPL-2.0 WITH Linux-syscall-note) OR CDDL-1.0) */
#   2 /* SPDX-License-Identifier: (GPL-2.0 WITH Linux-syscall-note) */
#   2 /* SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note
#   3 /* SPDX-License-Identifier: ((GPL-2.0 WITH Linux-syscall-note) OR MIT) */
#   4 /* SPDX-License-Identifier: (GPL-2.0 WITH Linux-syscall-note) OR MIT */
#   4 /* SPDX-License-Identifier: GPL-2.0-or-later WITH Linux-syscall-note */
#   4 /* SPDX-License-Identifier: LGPL-2.1 WITH Linux-syscall-note */
#   4 /* SPDX-License-Identifier: MIT */
#   5 /* SPDX-License-Identifier: ((GPL-2.0+ WITH Linux-syscall-note) OR BSD-3-Clause) */
#   5 /* SPDX-License-Identifier: BSD-3-Clause */
#   5 /* SPDX-License-Identifier: LGPL-2.0+ WITH Linux-syscall-note */
#   6 /* SPDX-License-Identifier: ((GPL-2.0 WITH Linux-syscall-note) OR BSD-2-Clause) */
#   6 /* SPDX-License-Identifier: ((GPL-2.0-only WITH Linux-syscall-note) OR BSD-3-Clause) */
#  11 /* SPDX-License-Identifier: GPL-1.0+ WITH Linux-syscall-note */
#  15 /* SPDX-License-Identifier: ((GPL-2.0 WITH Linux-syscall-note) OR Linux-OpenIB) */
#  16 /* SPDX-License-Identifier: LGPL-2.1+ WITH Linux-syscall-note */
#  24 # SPDX-License-Identifier: GPL-2.0
#  24 /* SPDX-License-Identifier: ((GPL-2.0 WITH Linux-syscall-note) OR BSD-3-Clause) */
#  26 /* SPDX-License-Identifier: GPL-2.0-only WITH Linux-syscall-note */
# 165 /* SPDX-License-Identifier: GPL-2.0+ WITH Linux-syscall-note */
# 993 /* SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note */
License: GPL-2.0-only with Linux-syscall-note
Group: Development/Kernel
Url: https://www.kernel.org/

Source1: cyclades.h

# git://git.altlinux.org/gears/g/%name.git
#Patch: %name-%version-%release.patch

Patch1: 0001-uapi-fix-linux-sysctl.h-userspace-compilation-errors.patch
Patch2: 0002-uapi-fix-linux-sysctl.h-Obsolete-types-detected-warn.patch
Patch3: 0003-uapi-fix-linux-vm_sockets.h-userspace-compilation-er.patch
Patch4: 0004-uapi-fix-linux-sctp.h-userspace-compilation-errors.patch
Patch5: 0005-uapi-fix-linux-omapfb.h-userspace-compilation-error.patch
Patch6: 0006-uapi-fix-linux-usb-audio.h-userspace-compilation-err.patch

BuildRequires: rpm-build-kernel rsync
BuildRequires: %kernel_source

%if 0%{!?mips:1}
%define mips mips mipsn32 mips64 mipsel mipsn32el mips64el
%endif

%ifarch %ix86 x86_32 x86_64 x32
%define base_arch x86
%endif
%ifarch %arm
%define base_arch arm
%endif
%ifarch aarch64
%define base_arch arm64
%endif
%ifarch ppc ppc64 ppc64le
%define base_arch powerpc
%endif
%ifarch riscv riscv64
%define base_arch riscv
%endif
%ifarch s390 s390x
%define base_arch s390
%endif
%ifarch %mips
%define base_arch mips
%endif
%ifarch loongarch64
%define base_arch loongarch
%endif
%if 0%{!?base_arch}
%{error:%_target_cpu is not supported}
%endif

Requires: %name-%base_arch = %EVR
Provides: kernel-headers = %EVR
Provides: linux-libc-headers = %EVR
Obsoletes: linux-libc-headers < %version

%description
This package includes the C header files that specify the interface
between the Linux kernel and userspace libraries and programs.
The header files define structures and constants that are needed for
building most standard programs and are also needed to build glibc.

%package generic
Summary: Generic Linux kernel C header files
Group: Development/Kernel
BuildArch: noarch
Conflicts: %name < %version
AutoReq: nocpp

%description generic
This package contains generic C header files that specify the interface
between the Linux kernel and userspace libraries and programs.
The header files define structures and constants that are needed for
building most standard programs and are also needed to build glibc.

%global kernel_arches %nil

%global do_package() \
%if 0%{2} \
%package %{1} \
Summary: %{1}-specific Linux kernel C header files \
Group: Development/Kernel \
BuildArch: noarch \
Requires: %name-generic = %EVR \
AutoReq: nocpp \
%description %{1} \
This package contains %{1}-specific C header files that specify \
the interface between the Linux kernel and userspace libraries and programs. \
The header files define structures and constants that are needed for \
building most standard programs and are also needed to build glibc. \
%endif

# In the kernel tree:
# ls arch/*/include/uapi/asm/Kbuild | sed -n 's|^arch/\([^/ ]\+\)/.*|\1|p' | sort | xargs echo %%define kernel_arches
%define kernel_arches alpha arc arm arm64 csky hexagon ia64 loongarch m68k microblaze mips nios2 openrisc parisc powerpc riscv s390 sh sparc x86 xtensa

# ls arch/*/include/uapi/asm/Kbuild | sed -n 's|^arch/\([^/ ]\+\)/.*|%%do_package \1 1|p' | sort
%do_package alpha 1
%do_package arc 1
%do_package arm 1
%do_package arm64 1
%do_package csky 1
%do_package hexagon 1
%do_package ia64 1
%do_package loongarch 1
%do_package m68k 1
%do_package microblaze 1
%do_package mips 1
%do_package nios2 1
%do_package openrisc 1
%do_package parisc 1
%do_package powerpc 1
%do_package riscv 1
%do_package s390 1
%do_package sh 1
%do_package sparc 1
%do_package x86 1
%do_package xtensa 1

%package all
Summary: All Linux kernel C header files
Group: Development/Kernel
BuildArch: noarch
Requires: %(for a in %kernel_arches; do printf '%%s = %%s ' %name-$a %EVR; done)

%description all
This package pulls in all other %name-* packages.

%prep
%setup -cT
tar -xf %kernel_src/%kernel_source.tar
cd %kernel_source
%autopatch -p1

# No exceptions, please!
sed -i 's/^no-export-headers/#&/' include/uapi/Kbuild

%build
mkdir -p headers
base_done=
for hdr_arch in %kernel_arches; do
	mkdir -p headers/"$hdr_arch"
	[ "$hdr_arch" != %base_arch ] || base_done=1
	make -C %kernel_source headers_install \
		ARCH="$hdr_arch" INSTALL_HDR_PATH="$PWD"/headers/"$hdr_arch" \
		&& rc= || rc=$?
	[ -z "$rc" ] || exit $rc
	find headers/"$hdr_arch"/include -name "*.install*" -delete
	mv headers/"$hdr_arch"/include/asm{,-"$hdr_arch"}
	install -pm644 %_sourcedir/cyclades.h headers/"$hdr_arch"/include/linux/
	(cd headers/"$hdr_arch"/include && find -type f -exec sha1sum {} +) |
		LC_COLLATE=C sort > "$hdr_arch".list
	if [ -s generic.list ]; then
		comm -12 generic.list "$hdr_arch".list > generic.list+
		mv generic.list+ generic.list
	else
		cp "$hdr_arch".list generic.list
	fi
done

for hdr_arch in %kernel_arches; do
	comm -23 "$hdr_arch".list generic.list > "$hdr_arch"-specific.list
done

sort -u *-specific.list |
	sed 's/.* //' |
	sort |
	uniq -d > dups.list
if [ -s dups.list ]; then
	cat >&2 dups.list
	exit 1
fi

[ -n "$base_done" ] || {
	echo >&2 "headers for %base_arch has not been generated"
	exit 1
}

ln -s generic.list generic-specific.list

%install
%define hdr_dir %_includedir/linux-default

gen_files()
{
	a="$1"; shift

	while read h file; do
		for dir in headers/*/include; do
			[ -f "$dir/$file" ] || continue
			install -pD -m644 "$dir/$file" \
				"%buildroot%hdr_dir/include/$file"
			echo "%hdr_dir/include${file#.}"
			break
		done
	done < "$a"-specific.list > package-"$a".files

	{
		sed -E -n 's|^(/.+/)[^/]+$|%dir \1|p' < package-"$a".files
		sed -E -n 's|^(/.+/)[^/]+/[^/]+$|%dir \1|p' < package-"$a".files
		sed -E -n 's|^(/.+/)[^/]+(/[^/]+){2}$|%dir \1|p' < package-"$a".files
	} > dir-"$a".files

	sort -u dir-"$a".files >> package-"$a".files
}

for hdr_arch in generic %kernel_arches; do
	gen_files "$hdr_arch"
done

ln -s asm-%base_arch %buildroot%hdr_dir/include/asm

%check
set +x
d="$PWD"
cd %buildroot%hdr_dir/include
find asm/ [^a]* -type f -name '*.h' |sort |while read f; do
	%__cc -D_GNU_SOURCE %optflags \
		-S -o/dev/null -xc /dev/null -I. -include "$f" ||
		echo "$f"
done > "$d"/fail.list
if [ -s "$d"/fail.list ]; then
	echo "Compilation check failed for $(grep -Fc .h -- "$d"/fail.list) files:"
	cat -- "$d"/fail.list
fi
cd - > /dev/null

%define _unpackaged_files_terminate_build 1

%global do_files() \
%if 0%{2} \
%files %{1} -f package-%{1}.files \
%endif

# ls arch/*/include/uapi/asm/Kbuild | sed -n 's|^arch/\([^/ ]\+\)/.*|%%do_files \1 1|p' | sort
%do_files alpha 1
%do_files arc 1
%do_files arm 1
%do_files arm64 1
%do_files csky 1
%do_files hexagon 1
%do_files ia64 1
%do_files loongarch 1
%do_files m68k 1
%do_files microblaze 1
%do_files mips 1
%do_files nios2 1
%do_files openrisc 1
%do_files parisc 1
%do_files powerpc 1
%do_files riscv 1
%do_files s390 1
%do_files sh 1
%do_files sparc 1
%do_files x86 1
%do_files xtensa 1

%files generic -f package-generic.files

%files all

%files
%dir %hdr_dir/
%dir %hdr_dir/include/
%hdr_dir/include/asm

%changelog
