%define _unpackaged_files_terminate_build 1
%define soname 4.13

Name: gmsh
Version: 4.13.1
Release: alt1

Summary: 3D finite element mesh generator
License: GPL-2.0-or-later
Group: Sciences/Mathematics
# upstream website looks like dead
Url: https://dev.opencascade.org/project/gmsh

# https://deb.debian.org/debian/pool/main/g/gmsh/gmsh_4.13.1+ds1.orig.tar.xz
Source: %name-%version.tar
Source1: %name.watch
Patch1: 0001-include-missing-cstdint.patch
Patch3: gmsh-debian-ix86-gcc14-compat.patch
Patch4: 30_delete_gl2ps_from_source.patch

Requires: libgmsh%soname = %EVR

BuildRequires(pre): rpm-build-python
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: fontconfig-devel
BuildRequires: gcc-c++
BuildRequires: gcc-fortran
BuildRequires: getfemxx
BuildRequires: libGLU-devel
BuildRequires: libX11-devel
BuildRequires: libXcursor-devel
BuildRequires: libXext-devel
BuildRequires: libXfixes-devel
BuildRequires: libXft-devel
BuildRequires: libXinerama-devel
BuildRequires: libXrender-devel
BuildRequires: libann-devel
BuildRequires: libfltk-devel
BuildRequires: libfreeglut-devel
BuildRequires: libfreetype-devel
BuildRequires: libgl2ps-devel
BuildRequires: libglvnd-devel
BuildRequires: libjpeg-devel
BuildRequires: liblapack-devel
BuildRequires: libopenblas-devel
BuildRequires: libpng-devel
BuildRequires: opencascade-devel
BuildRequires: zlib-devel

%description
Gmsh is an automatic 3D finite element grid generator with a built-in CAD engine
and post-processor. Its design goal is to provide a simple meshing tool for
academic problems with parametric input and advanced visualization capabilities.

Gmsh is built around four modules: geometry, mesh, solver and post-processing.
The specification of any input to these modules is done either interactively
using the graphical user interface or in ASCII text files using Gmsh's own
scripting language.


%package -n libgmsh%soname
Summary: Shared library for Gmsh
Group: Sciences/Mathematics
%description -n libgmsh%soname
This package contains libgmsh shared library.


%package -n libgmsh-devel
Summary: Shared library for Gmsh
Group: Sciences/Mathematics
%description -n libgmsh-devel
This package contains development files for libgmsh.


%package -n python-module-gmsh
Summary: Python interface for libgmsh
Group: Sciences/Mathematics
BuildArch: noarch
%description -n python-module-gmsh
This package contains python interface for libgmsh.


%package demos
Summary: Tutorial and example files for Gmsh
Group: Sciences/Mathematics
BuildArch: noarch
%description demos
This package contains tutorial and example files for gmsh.

%prep
%setup
%patch1 -p2
%ifarch %e2k
# need to disable workarounds for GCC
sed -i "s/EIGEN_GNUC_AT_LEAST(6,0)/0/" \
  contrib/eigen/Eigen/src/Core/products/GeneralBlockPanelKernel.h
%endif
%patch3 -p1
%patch4 -p1

%build
# 1. Dynamic library and private API is needed for compiling getdb
# 2. In Altlinux autodetection does not work correctly for
#    libopenblas + liblapack, BLAS_LAPACK_LIBRARIES should be set.
%cmake_insource\
   -DCMAKE_BUILD_TYPE=Release\
   -DENABLE_BUILD_DYNAMIC=1\
   -DENABLE_PRIVATE_API=1\
   -DBLAS_LAPACK_LIBRARIES="-lopenblas -llapack"

%make_build VERBOSE=1

%install
%makeinstall_std

mkdir -p %buildroot%python_sitelibdir_noarch
mv %buildroot%_libdir/*.py %buildroot%python_sitelibdir_noarch
mv %buildroot%_bindir/*.py %buildroot%python_sitelibdir_noarch
mv %buildroot%_libdir/gmsh-%version.dev1.dist-info \
   %buildroot%python_sitelibdir_noarch/gmsh-%version.dist-info

rm -f %buildroot%_libdir/*.jl

%files
%_bindir/gmsh
%_man1dir/gmsh.*
%dir %_docdir/gmsh
%doc %_docdir/gmsh/*.txt

%files -n libgmsh%soname
%_libdir/libgmsh.so.*

%files -n libgmsh-devel
%_includedir/*
%_libdir/libgmsh.so

%files -n python-module-gmsh
%python_sitelibdir_noarch/*

%files demos
%_docdir/gmsh/examples
%_docdir/gmsh/tutorials


%changelog
