%def_enable snapshot
%define optflags_lto %nil

%define xdg_name org.gnome.Builder
%define ver_major 48
%define beta %nil
%define _libexecdir %_prefix/libexec
%define api_ver %ver_major.0

%def_enable clang
%def_enable sysprof
%def_enable flatpak
%def_disable docs
%def_enable help
%def_enable autotools
# disabled by default
%def_enable vala

Name: gnome-builder
Version: %ver_major.3
Release: alt1%beta

Summary: Builder - Develop software for GNOME
License: GPL-3.0-or-later
Group: Development/GNOME and GTK+
Url: https://apps.gnome.org/Builder

Vcs: https://gitlab.gnome.org/GNOME/gnome-builder.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif
#https://l10n.gnome.org/media/upload/gnome-builder-master-po-ru-955618_BWaCuRU.po
Source1: %name-ru.po

%set_typelibdir %_libdir/%name/girepository-1.0

%define glib_ver 2.76.0
%define gtk_ver 4.16
%define adwaita_ver 1.6
%define panel_ver 1.7
%define gtksourceview_api_ver 5
%define gtksourceview_ver 5.15
%define git2_ver 1.1.0
%define devhelp_ver 3.30.0
%define xml_ver 2.9.0
%define vala_ver 0.37
%define sysprof_ver 45
%define vte_ver 0.70
%define gtkmm_ver 3.20
%define peas_ver 2.0.0
%define json_glib_ver 1.2.0
%define template_glib_ver 3.36.1
%define soup3_ver 3.0
%define webkit_api_ver 6.0
%define webkit_ver 2.40.0
%define portal_ver 0.5
%define gi_docgen_ver 2021.9
%define jsonrpc_ver 3.43.0
%define dex_ver 0.7

%add_python3_path %_libdir/%name/plugins
%add_findreq_skiplist %_datadir/%name/plugins/*_templates/resources/*/*.py

Requires(pre): %name-data = %EVR
# src/libide/gui/ide-application-plugins.c
Requires: typelib(WebKit) = %webkit_api_ver
Requires: typelib(Jsonrpc) = 1.0
Requires: typelib(Json) = 1.0

%{?_with_autotools:Requires: automake autoconf libtool}
#%{?_with_flatpak:Requires: flatpak-builder}
Requires: meson %_bindir/git %_bindir/indent %_bindir/xmllint
Requires: devhelp %_bindir/uncrustify %_bindir/ctags %_bindir/cmark
Requires: libpeas2-python3-loader

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: /proc meson gcc-c++ flex mm-common yelp-tools
BuildRequires: %_bindir/ctags %_bindir/tidy %_bindir/uncrustify
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: /usr/bin/appstream-util desktop-file-utils
BuildRequires: libgtk4-devel >= %gtk_ver libadwaita-devel >= %adwaita_ver
BuildRequires: libpanel-devel >= %panel_ver
BuildRequires: libgtksourceview%gtksourceview_api_ver-devel >= %gtksourceview_ver
BuildRequires: libgit2-glib-devel >= %git2_ver libdevhelp-devel >= %devhelp_ver
BuildRequires: libwebkitgtk%webkit_api_ver-devel >= %webkit_ver
BuildRequires: libxml2-devel >= %xml_ver libpeas2-devel >= %peas_ver libvte3-devel >= %vte_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver libpcre2-devel
BuildRequires: python3-devel python3-module-pygobject3-devel
BuildRequires: gobject-introspection-devel libgtk4-gir-devel libpanel-gir-devel libvte3-gir-devel
BuildRequires: libgtksourceview%gtksourceview_api_ver-gir-devel libgit2-glib-gir-devel libpeas2-gir-devel
BuildRequires: libjson-glib-gir-devel libsoup3.0-gir-devel >= %soup3_ver libwebkitgtk%webkit_api_ver-gir-devel
BuildRequires: libvala-devel >= %vala_ver vala-tools
BuildRequires: pkgconfig(libspelling-1) libenchant2-devel
BuildRequires: libtemplate-glib-devel >= %template_glib_ver libeditorconfig-devel
BuildRequires: libjsonrpc-glib-devel >= %jsonrpc_ver
BuildRequires: libtemplate-glib-gir-devel libjsonrpc-glib-gir-devel
BuildRequires: libdex-gir-devel
BuildRequires: libgtkmm4-devel >= %gtkmm_ver
BuildRequires: cmark-devel
BuildRequires: pkgconfig(libportal-gtk4)
BuildRequires: libdex-devel >= %dex_ver
BuildRequires: pkgconfig(gom-1.0)
%{?_enable_clang:BuildRequires: llvm-devel clang-devel}
%{?_enable_docs:BuildRequires: gi-docgen >= %gi_docgen_ver}
%{?_enable_help:BuildRequires: python3-module-sphinx python3-module-sphinx_rtd_theme}
%{?_enable_flatpak:BuildRequires: libflatpak-devel libostree-devel libportal-devel >= %portal_ver}
%{?_enable_sysprof:BuildRequires: sysprof-devel >= %sysprof_ver}

%description
Builder attempts to be an IDE for writing software for GNOME. It does not
try to be a generic IDE, but one specialized for writing GNOME software.
We believe that this focus will help us to build something great.

%package data
Summary: Arch independent files for GNOME Builder
Group: Development/GNOME and GTK+
BuildArch: noarch

%description data
This package provides noarch data needed for Gnome Builder to work.

%package clang
Summary: Clang/LLVW dependent part for GNOME Builder
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description clang
This package provides files for Gnome Builder to work with Clang/LLVW.

%prep
%setup -n %name-%version%beta
%python3_fix_shebang src/plugins/*/*.py

%build
%meson \
    %{subst_enable_meson_bool clang plugin_clang} \
    %{subst_enable_meson_bool sysprof plugin_sysprof} \
    %{subst_enable_meson_bool docs docs} \
    %{subst_enable_meson_bool help help} \
    %{subst_enable_meson_bool flatpak plugin_flatpak} \
    %{subst_enable_meson_bool autotools plugin_autotools} \
%nil
%meson_build -v

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-git
%_libexecdir/%name-flatpak
%dir %_libdir/%name
%dir %_libdir/%name/girepository-1.0
%_libdir/%name/girepository-1.0/Ide-%ver_major.typelib
%_includedir/%name-%ver_major/
%_pkgconfigdir/%name-%version.pc
%doc README* AUTHORS NEWS

%if_enabled clang
%files clang
%_libexecdir/%name-clang
%endif

%files data
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/org.gnome.builder.build.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.clang.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.code-insight.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.copyright.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.debug.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.editor.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.editor.language.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.extension-type.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.flatpak.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.plugin.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.project.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.project-tree.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.shellcmd.command.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.shellcmd.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.spelling.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.sysprof.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.terminal.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.builder.valgrind.gschema.xml
%_datadir/%name/
%_iconsdir/hicolor/*/*/*.*
%_datadir/metainfo/%xdg_name.appdata.xml

%{?_enable_docs:%_datadir/doc/libide/}
%{?_enable_help:%_datadir/doc/%name/}

%changelog
