%def_disable snapshot
%define xdg_name org.gnome.clocks
%define ver_major 48
%define beta %nil

%def_enable waked
%def_enable check

Name: gnome-clocks
Version: %ver_major.0
Release: alt1%beta

Summary: Clock application designed for GNOME 3
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Apps/Clocks

Vcs: https://gitlab.gnome.org/GNOME/gnome-clocks.git

%if_disabled snapshot
Source: https://download.gnome.org/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif
# https://bugzilla.altlinux.org/51204
Patch10: %name-46.0-alt-waked.patch

%define glib_ver 2.72
%define gweather_ver 3.99
%define geocode_ver 3.26.0
%define geoclue_ver 2.4
%define gtk4_ver 4.16
%define adwaita_ver 1.6

Requires: geoclue2
%{?_enable_waked:Requires: waked}

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools glib2-devel >= %glib_ver
BuildRequires: yelp-tools
BuildRequires: libgtk4-devel >= %gtk4_ver
BuildRequires: libgsound-devel pkgconfig(gnome-desktop-4)
BuildRequires: gobject-introspection-devel libgtk4-gir-devel libgweather4.0-vala
BuildRequires: libgweather4.0-devel >= %gweather_ver libgeocode-glib2.0-devel >= %geocode_ver
BuildRequires: libgeoclue2-devel >= %geoclue_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
%{?_enable_check:BuildRequires:/usr/bin/appstreamcli  desktop-file-utils}

%description
Clock application designed for GNOME 3

%prep
%setup -n %name-%version%beta
%patch10 -p1 -b .waked

%build
%meson \
    %{subst_enable_meson_bool waked waked}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_datadir/applications/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_iconsdir/hicolor/*/*/%{xdg_name}*.*
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* NEWS*

%changelog
