%define ver_major 46
%define beta %nil
%define xdg_name org.gnome.DiskUtility
%define _libexecdir %_prefix/libexec
%def_enable gsd_plugin
%def_enable libsystemd
%def_enable check

Name: gnome-disk-utility
Version: %ver_major.1
Release: alt1.1%beta

Summary: Disk management application
License: GPL-2.0-or-later
Group: System/Configuration/Hardware
Url: https://apps.gnome.org/DiskUtility

Requires: udisks2 cryptsetup
Requires: gnome-icon-theme-symbolic

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz

%define udisks_ver 2.7.6
%define glib_ver 2.31.0
%define gtk_ver 3.16.0
%define secret_ver 0.7
%define pwquality_ver 1.0.0
%define dvdread_ver 4.2.0
%define lzma_ver 5.0.5
%define handy_ver 1.5.0

Provides: gnome-disks = %EVR
Requires: udisks2 >= %udisks_ver
Requires: libblockdev-tools

BuildRequires(pre): rpm-macros-meson rpm-build-xdg
BuildRequires: meson
BuildRequires: libudisks2-devel >= %udisks_ver
BuildRequires: libgio-devel  >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: libsecret-devel >= %secret_ver
BuildRequires: libpwquality-devel >= %pwquality_ver
BuildRequires: libdvdread-devel >= %dvdread_ver
BuildRequires: liblzma-devel >= %lzma_ver
BuildRequires: libnotify-devel libcanberra-gtk3-devel
%{?_enable_libsystemd:BuildRequires: pkgconfig(systemd)}
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}
BuildRequires: xsltproc docbook-style-xsl

%description
This package contains the Palimpsest disk management application.
Palimpsest supports partitioning, file system creation, encryption,
RAID, SMART monitoring, etc

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool gsd_plugin gsd_plugin} \
    -Dlogind='libsystemd'
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=global.lang %name

%check
%__meson_test

%files -f global.lang
%_bindir/gnome-disk-image-mounter
%_bindir/gnome-disks

%if_enabled gsd_plugin
%_libexecdir/gsd-disk-utility-notify
%_xdgconfigdir/autostart/org.gnome.SettingsDaemon.DiskUtilityNotify.desktop
%endif

%_desktopdir/gnome-disk-image-mounter.desktop
%_desktopdir/gnome-disk-image-writer.desktop
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/org.gnome.Disks.gschema.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/metainfo/%xdg_name.appdata.xml
%_man1dir/*.1.*


%changelog
