%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define xdg_name org.gnome.Shell
%define ver_major 48
%define beta %nil
%define api_ver 16
%define gst_api_ver 1.0
%define gvc_ver 5f9768a

%def_enable x11
%def_enable extensions_tool
%def_enable extensions_app
%def_disable gtk_doc
%def_enable man
%def_disable check

Name: gnome-shell
Version: %ver_major.4
Release: alt1%beta

Summary: Window management and application launching for GNOME
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Projects/GnomeShell

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif
%{?_enable_snapshot:Source1: libgnome-volume-control-%gvc_ver.tar}

Patch3: %name-48.1-alt-invalid_user_shell.patch
Patch4: %name-48.3-alt-no_yast-pardus_folders.patch
# https://bugzilla.altlinux.org/54831
# https://gitlab.gnome.org/GNOME/gnome-shell/-/merge_requests/3252
#Patch10: XXX

Obsoletes: gnome-shell-extension-per-window-input-source

%define session_ver 3.26
%define gjs_ver 1.73.1
%define mutter_ver %ver_major
%define gtk_ver 4.0
%define adwaita_ver 1.0
%define gio_ver 2.56.0
%define gstreamer_ver 1.0
%define eds_ver 3.34.0
%define polkit_ver 0.100
%define bt_api_ver 3.0
%define bluetooth_ver 3.11.3
%define folks_ver 0.5.2
%define gi_ver 1.49.1
%define sn_ver 0.11
%define gcr_api_ver 4
%define gcr_ver 3.90.0
%define atspi_ver 2.5.91
%define menus_ver 3.5.3
%define desktop_ver 3.35.90
%define json_glib_ver 0.13.2
%define nm_ver 1.10.4
%define ibus_ver 1.5.19
%define gsds_ver 47
%define libsecret_ver 0.18
%define malcontent_ver 0.11
%define gweather_api_ver 4.0
%define webkit_api_ver 6.0

Requires: %name-data = %EVR
# to avoid circular dependency
%filter_from_requires /\/usr\/bin\/%name/d
Requires: mutter-gnome >= %mutter_ver libmutter-gir >= %mutter_ver
Requires: gnome-session >= %session_ver
Requires: dconf at-spi2-core gnome-icon-theme gnome-icon-theme-symbolic
Requires: at-spi2-atk ca-certificates polkit
# since 3.11.x requires org.gnome.login-screen schema
Requires: gdm-data
Requires: tecla
# network.js requires
Requires: gnome-control-center
# since 3.16
# 
#Requires: polari
# for OSK
Requires: ibus ibus-gtk4
# for zipped extensions
Requires: unzip
# synce 3.38
Requires: malcontent >= %malcontent_ver
Requires: pipewire
Requires: xdg-desktop-portal-gnome
Requires: fonts-ttf-adwaita
#Requires: localsearch

# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
# js/misc/dependencies.js
Requires: typelib(AccountsService)
Requires: typelib(Atk)
Requires: typelib(Atspi)
Requires: typelib(Clutter)
Requires: typelib(Gcr) = %gcr_api_ver
Requires: typelib(GDesktopEnums) = 3.0
Requires: typelib(Gdk) = 4.0
Requires: typelib(GdkPixbuf)
Requires: typelib(Gdm)
Requires: typelib(Geoclue)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GnomeBluetooth) = %bt_api_ver
Requires: typelib(GnomeDesktop)
Requires: typelib(GObject)
Requires: typelib(Graphene)
Requires: typelib(Gst)
Requires: typelib(Gtk) = 4.0
Requires: typelib(Gvc)
Requires: typelib(GWeather) = %gweather_api_ver
Requires: typelib(IBus)
Requires: typelib(Malcontent)
Requires: typelib(Meta)
Requires: typelib(MetaTest)
Requires: typelib(NM)
Requires: typelib(NMA4) = 1.0
Requires: typelib(Pango)
Requires: typelib(Polkit)
Requires: typelib(PolkitAgent)
Requires: typelib(Rsvg)
Requires: typelib(Shell)
Requires: typelib(Shew)
Requires: typelib(Soup) = 3.0
Requires: typelib(St)
Requires: typelib(UPowerGlib)
Requires: typelib(WebKit) = %webkit_api_ver

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires(pre): rpm-build-python3 rpm-build-xdg rpm-build-systemd
BuildRequires: meson gcc-c++ xsltproc asciidoc-a2x sassc /usr/bin/jasmine
BuildRequires: /usr/bin/appstreamcli desktop-file-utils
BuildRequires: bash-completion
BuildRequires: python3-devel
BuildRequires: libmutter-devel >= %mutter_ver libmutter-gir-devel
BuildRequires: libgjs-devel >= %gjs_ver
BuildRequires: libgio-devel >= %gio_ver
# for Shew
BuildRequires: libgtk4-devel >= %gtk_ver libgtk4-gir-devel pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: at-spi2-atk-devel >= %atspi_ver
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: libxml2-devel
BuildRequires: libgnome-menus-devel >= %menus_ver libgnome-menus-gir-devel
BuildRequires: libGConf-devel
BuildRequires: libgnome-desktop3-devel >= %desktop_ver
BuildRequires: pkgconfig(gcr-%gcr_api_ver) >= %gcr_ver
BuildRequires: libstartup-notification-devel >= %sn_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: libcanberra-devel libcanberra-gtk3-devel
BuildRequires: libalsa-devel libpulseaudio-devel
BuildRequires: pkgconfig(gnome-bluetooth-%bt_api_ver) >= %bluetooth_ver libgnome-bluetooth%bt_api_ver-gir-devel
BuildRequires: evolution-data-server-devel >= %eds_ver libicu-devel
# for screencast recorder functionality
BuildRequires: gstreamer%gst_api_ver-devel >= %gstreamer_ver gst-plugins%gst_api_ver-devel pkgconfig(libpipewire-0.3)
BuildRequires: libXfixes-devel
BuildRequires: mutter >= %mutter_ver
BuildRequires: libpolkit-devel >= %polkit_ver
BuildRequires: libfolks-devel >= %folks_ver libfolks-gir-devel
BuildRequires: libnm-devel >= %nm_ver libnm-gir-devel
BuildRequires: libgudev-devel libgudev-gir-devel
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libsoup3.0-gir-devel ca-certificates
BuildRequires: gnome-control-center-devel
BuildRequires: pkgconfig(systemd)
BuildRequires: libibus-devel >= %ibus_ver
BuildRequires: gir(Gcr) = %gcr_api_ver libsecret-devel >= %libsecret_ver libpolkit-gir-devel
BuildRequires: libgnome-autoar-devel
BuildRequires: pkgconfig(tecla)
%{?_enable_x11:BuildRequires: libX11-devel libXfixes-devel}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_man:BuildRequires: /usr/bin/rst2man}

%description
GNOME Shell provides core user interface functions for the GNOME 3 desktop,
like switching to windows and launching applications. GNOME Shell takes
advantage of the capabilities of modern graphics hardware and introduces
innovative user interface concepts to provide a visually attractive and
easy to use experience.

%package data
Summary: Arch independent files for GNOME Shell
Group: Graphical desktop/GNOME
BuildArch: noarch

%description data
This package provides noarch data needed for Gnome Shell to work.

%package devel-doc
Group: Development/Other
Summary: Development documentation for GNOME Shell
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
This package contains documentation needed to develop extensions for
GNOME Shell.

%package -n gnome-extensions-app
Summary: GNOME Shell extensions manager
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description -n gnome-extensions-app
GNOME Extensions handles updating extensions, configuring extension
preferences and removing or disabling unwanted extensions.

%set_typelibdir %_libdir/%name

%prep
%setup -n %name-%version%beta %{?_enable_snapshot:-a1
mkdir subprojects/gvc
cp -a libgnome-volume-control-%gvc_ver/* subprojects/gvc/}

%patch3 -b .shells
%patch4 -b .default_folders

# set full path to gsettings
sed -i 's|=\(gsettings\)|=%_bindir/\1|' data/%xdg_name-disable-extensions.service

%build
%meson \
    %{subst_enable_meson_bool gtk_doc gtk_doc} \
    %{subst_enable_meson_bool extensions_tool extensions_tool} \
    %{subst_enable_meson_bool extensions_app extensions_app} \
    %{?_enable_snapshot:%meson_build %name-pot %name-update-po}
#%meson_build %name-pot %name-update-po
%nil
%meson_build -v

%install
%meson_install
%find_lang %name

%check
%meson_test

%files
%_bindir/%name
#%_bindir/%name-extension-prefs
%_bindir/%name-test-tool
%{?_enable_extensions_tool:%_bindir/gnome-extensions
%_bindir/gnome-shell-extension-tool}
%_libexecdir/%name-calendar-server
%_libexecdir/%name-perf-helper
%_libexecdir/%name-hotplug-sniffer
%_libexecdir/%name-portal-helper
%dir %_libdir/%name
%_libdir/%name/lib%name-menu.so
%_libdir/%name/libgvc.so
%_libdir/%name/libshell-%api_ver.so
%_libdir/%name/libst-%api_ver.so
%_libdir/%name/libshew-0.so
%_libdir/%name/*.typelib
%dir %_libdir/%name/girepository-1.0
%_libdir/%name/girepository-1.0/Shew-0.typelib

%files data -f %name.lang
%{?_enable_extensions_tool:%_datadir/bash-completion/completions/gnome-extensions}
%_desktopdir/%xdg_name.desktop
%_desktopdir/%xdg_name.Extensions.desktop
%_desktopdir/%xdg_name.PortalHelper.desktop
%_datadir/%name/
%_datadir/dbus-1/services/%xdg_name.CalendarServer.service
%_datadir/dbus-1/services/%xdg_name.HotplugSniffer.service
%_datadir/dbus-1/interfaces/%xdg_name.Introspect.xml
%_datadir/dbus-1/interfaces/%xdg_name.PadOsd.xml
%_datadir/dbus-1/interfaces/%{xdg_name}SearchProvider.xml
%_datadir/dbus-1/interfaces/%xdg_name.Screenshot.xml
%_datadir/dbus-1/interfaces/%{xdg_name}SearchProvider2.xml
%_datadir/dbus-1/interfaces/%xdg_name.Screencast.xml
%_datadir/dbus-1/interfaces/%xdg_name.ScreenTime.xml
%_datadir/dbus-1/interfaces/%xdg_name.Extensions.xml
%_datadir/dbus-1/services/%xdg_name.Extensions.service
%_datadir/dbus-1/services/%xdg_name.Notifications.service
%_datadir/dbus-1/services/%xdg_name.PortalHelper.service
%_datadir/dbus-1/services/%xdg_name.Screencast.service
%_datadir/dbus-1/services/org.gnome.ScreenSaver.service
%_datadir/gnome-control-center/keybindings/50-%name-launchers.xml
%_datadir/gnome-control-center/keybindings/50-%name-system.xml
%_datadir/gnome-control-center/keybindings/50-%name-screenshots.xml
%config %_datadir/glib-2.0/schemas/org.gnome.shell.gschema.xml
%config %_datadir/glib-2.0/schemas/00_org.gnome.shell.gschema.override
%_userunitdir/%xdg_name-disable-extensions.service
%_userunitdir/%xdg_name.target
%_userunitdir/%{xdg_name}@wayland.service
%_userunitdir/%{xdg_name}@x11.service

%_man1dir/*
%_iconsdir/hicolor/*/*/%xdg_name.Extensions*.svg
%_iconsdir/hicolor/*/*/%xdg_name.CaptivePortal*.svg

%_datadir/desktop-directories/X-GNOME-Shell-System.directory
%_datadir/desktop-directories/X-GNOME-Shell-Utilities.directory
%doc README* NEWS

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/shell/
%_datadir/gtk-doc/html/st/
%endif

%{?_enable_extensions_app:
%files -n gnome-extensions-app
%_bindir/gnome-extensions-app
%_desktopdir/org.gnome.Extensions.desktop
%config %_datadir/glib-2.0/schemas/org.gnome.Extensions.gschema.xml
%_datadir/metainfo/org.gnome.Extensions.metainfo.xml
%_datadir/dbus-1/services/org.gnome.Extensions.service
%_iconsdir/hicolor/*/*/org.gnome.Extensions*.svg
}

%changelog
