# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: gnome-shell-extension-dash-to-panel
Version: 68
Release: alt5.119a5928.1

%define sname dash-to-panel
%define eid dash-to-panel@jderose9.github.com

Summary: An icon taskbar for the Gnome Shell

BuildArch: noarch

License: GPL-2.0
Group:  Graphical desktop/GNOME
Url: https://github.com/home-sweet-gnome/dash-to-panel
Vcs: https://github.com/home-sweet-gnome/dash-to-panel

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: gnome-shell >= 47.0

%define gettext_domain dash-to-panel

BuildRequires: %_bindir/glib-compile-schemas sassc eslint

%description
An icon taskbar for the Gnome Shell.
This extension moves the dash into the gnome main panel so that the application
launchers and system tray are combined into a single panel,
similar to that found in KDE Plasma and Windows 7+. A separate dock is no longer
needed for easy access to running and favorited applications.

%prep
%setup
%__subst  's/"version": [[:digit:]][[:digit:]]*/"version": %version/'  metadata.json;
%autopatch -p1

%build
%make_build

%install
%makeinstall_std
%find_lang %gettext_domain

# remove docs from directory of extension
rm %buildroot%_datadir/gnome-shell/extensions/%eid/COPYING
rm %buildroot%_datadir/gnome-shell/extensions/%eid/README.md

%files -f %gettext_domain.lang
%_datadir/gnome-shell/extensions/%eid/*
%_datadir/glib-2.0/schemas/org.gnome.shell.extensions.dash-to-panel.gschema.xml
%doc README.md COPYING

%changelog
