%def_enable snapshot

%define _name openweather
%define git_name gnome-%_name
%define ver_major 139
%define beta %nil
%define uuid %_name-extension@penguin-teal.github.io
%define xdg_name org.gnome.shell.extensions.%{_name}refined
%define gettext_domain gnome-shell-extension-%{_name}refined

%def_enable check

Name: gnome-shell-extension-%_name
Version: %ver_major
Release: alt2

Summary: Weather extension for the GNOME Shell
Group: Graphical desktop/GNOME
License: GPL-3.0-or-later
Url: https://github.com/penguin-teal/gnome-openweather

Vcs: https://github.com/penguin-teal/gnome-openweather.git

BuildArch: noarch

%if_disabled snapshot
Source: %url/archive/v%version%beta/%git_name-%version%beta.tar.gz
%else
Source: %git_name-%version%beta.tar
%endif
# https://github.com/penguin-teal/gnome-openweather/pull/92
Patch10: %git_name-139-up-formatKey.patch
Patch11: %git_name-139-alt-gnome-48.patch
# https://github.com/penguin-teal/gnome-openweather/pull/97
Patch12: %git_name-139-up-ru.po.patch

Requires: gnome-shell >= 45
Requires: typelib(Adw) = 1
Requires: geoclue2 typelib(Geoclue)

BuildRequires: /usr/bin/glib-compile-schemas

%description
OpenWeather (gnome-shell-extension-openweather) is a simple extension
for displaying weather conditions and forecasts for any location on Earth
in the GNOME Shell. It provides support for multiple locations with
editable names using coordinates to store the locations, a beautiful
layout, and more.

Weather data is fetched from OpenWeatherMap (https://openweathermap.org)
including 3 hour forecasts for up to 5 days.

%prep
%setup -n %git_name-%version%beta
%patch10 -p1
%patch11 -p1
%patch12 -p1

%build
%make VERSION=%version

%install
%makeinstall_std
%find_lang %gettext_domain


%files -f %gettext_domain.lang
%_datadir/gnome-shell/extensions/%uuid/
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%doc AUTHORS README.md CHANGELOG*

%changelog
