# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%def_with doc

%add_findreq_skiplist %python3_sitelibdir/gns3server/compute/docker/*
%add_python3_req_skip prompt_toolkit.eventloop.base
%add_python3_req_skip prompt_toolkit.interface
%add_python3_req_skip prompt_toolkit.key_binding.input_processor
%add_python3_req_skip prompt_toolkit.terminal.vt100_output

Name: gns3-server
Version: 2.2.52
Release: alt1

Summary: GNS3 server manages emulators such as Dynamips, VirtualBox or Qemu/KVM
License: GPL-3.0-or-later
Group: Emulators
Url: https://github.com/GNS3/gns3-server
Vcs: https://github.com/GNS3/gns3-server.git

Buildarch: noarch

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-python3
BuildRequires: rpm-build-python3 rpm-build-gir
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3-module-importlib-resources

%if_with doc
BuildRequires: python3-module-sphinx
%endif
Requires: cpulimit
Requires: dynamips >= 0.2.11
Requires: iouyap
Requires: ubridge
Requires: vpcs
Requires(pre): busybox
Conflicts: gns3 < 1.0.0

%description
The GNS3 server manages emulators such as Dynamips, VirtualBox or Qemu/KVM.
Clients like the GNS3 GUI controls the server using a HTTP REST API.

%package doc
Summary: Documentation for %name
Group: Documentation

%description doc
Documentation for %name.

%prep
%setup
%autopatch -p1
echo '' > requirements.txt

# Don't bundle busybox with the package
sed -i -r '/^copy_busybox/d' setup.py

# Don't bundle OVMF_CODE.fd OVMF_VARS.fd with the package
rm -fv %buildroot/%python3_sitelibdir/gns3server/disks/OVMF_CODE.fd
rm -fv %buildroot/%python3_sitelibdir/gns3server/disks/OVMF_VARS.fd

%build
%pyproject_build

# Build the doc1834283s
%make_build -C docs html SPHINXBUILD=py3_sphinx-build
/bin/rm -f docs/_build/html/.buildinfo

%install
%pyproject_install

%ifnarch %ix86 x86_64
rm tests/controller/gns3vm/test_virtualbox_gns3_vm.py
%endif

touch %buildroot%python3_sitelibdir/gns3server/compute/docker/resources/bin/busybox

# Remove shebang
find %buildroot/%python3_sitelibdir/ -name '*.py' -print \
   -exec sed -i '1{\@^#!/usr/bin/env python@d}' {} \;

# Set bit execution
find %buildroot/%python3_sitelibdir/ -name '*.sh' -print \
   -exec chmod +x {} \;
chmod +x %buildroot/%python3_sitelibdir/gns3server/compute/docker/resources/bin/udhcpc
chmod +x %buildroot/%python3_sitelibdir/gns3server/compute/docker/resources/etc/udhcpc/default.script

# Remove empty file
rm -f %buildroot/%python3_sitelibdir/gns3server/symbols/.gitkeep

%post
# Replace bundled busybox with ALT Linux one
cp -fp /bin/busybox %python3_sitelibdir/gns3server/compute/docker/resources/bin/busybox

# Replace bundled OVMF_CODE.fd OVMF_VARS.fd with ALT Linux ones
#cp -fp %_datadir/edk2/ovmf/OVMF_CODE.fd %python3_sitelibdir/gns3server/disks/OVMF_CODE.fd
#cp -fp %_datadir/edk2/ovmf/OVMF_VARS.fd %python3_sitelibdir/gns3server/disks/OVMF_VARS.fd

%files
%doc README.md AUTHORS CHANGELOG
%_bindir/*
%python3_sitelibdir/gns3server
%python3_sitelibdir/gns3_server-%version.dist-info/
%ghost %python3_sitelibdir/gns3server/compute/docker/resources/bin/busybox
%ghost %python3_sitelibdir/gns3server/disks/OVMF_CODE.fd
%ghost %python3_sitelibdir/gns3server/disks/OVMF_VARS.fd

%files doc
%doc docs/_build/html

%changelog
