Name: google-drive-ocamlfuse
Version: 0.7.32
Release: alt1
License: BSD-2-Clause
Summary: FUSE filesystem for Google Drive
Url: http://gdfuse.forge.ocamlcore.org
Group: Networking/Remote access
# https://github.com/astrada/google-drive-ocamlfuse
Source: %name-%version.tar
BuildRequires: dune 
BuildRequires: ocaml-ocamlfuse-devel
BuildRequires: ocaml-gapi-devel >= 0.4.1-alt1
BuildRequires: ocaml-sqlite3-devel
BuildRequires: ocaml-tiny_httpd-devel
BuildRequires: ocaml-cryptokit-devel
BuildRequires: ocaml-extlib-devel
BuildRequires: ocaml-camlidl-devel >= 1.06-alt1
BuildRequires: libsqlite3-devel
BuildRequires: libcurl-devel
BuildRequires: zlib-devel
BuildRequires: libfuse-devel
BuildRequires: libgmp-devel

%description
google-drive-ocamlfuse is a FUSE-based file system backed by Google Drive,
written in OCaml. It lets you mount your Google Drive on Linux.

On the first time, just run google-drive-ocamlfuse, which will open a
browser for authentication. If that process succeeds, it will print
"Access token retrieved correctly.". Now run google-drive-ocamlfuse
with an empty directory supplied, which is the mount point for your Google
Drive. You can optionally unmount with fusermount -u mount-point.

Further documentation is available here:

  https://github.com/astrada/google-drive-ocamlfuse/wiki

%prep
%setup

%build
%dune_build -p %name

%install
%dune_install

%files
%doc README.md doc/ LICENSE
%_bindir/%name
%_libdir/ocaml/%name

%changelog
