%def_without bootstrap

%if_without bootstrap
# help is welcome to re-enable, fix packaging and test
%def_disable guile
%def_enable lua
%def_disable ocaml
%def_disable php
%def_disable python2
%def_enable python3
%def_disable ruby
%def_enable tcl
%endif

%define gvdatadir %_datadir/%name
%define gvlibdir %_libdir/%name
%define gvtcldir %_libexecdir/%name/tcl

# Fix for the 387 extended precision (rhbz#772637)
%ifarch %ix86
%global FFSTORE -ffloat-store
%endif


Name: graphviz
Version: 11.0.0
Release: alt2

Summary: Graphs visualization tools
License: EPL-1.0 and GPL-2.0+ with Bison-exception and CPL-1.0
Group: Publishing
Packager: Fr. Br. George <george@altlinux.org>
Url: https://www.graphviz.org
Vcs: https://gitlab.com/graphviz/graphviz
Source0: %name-%version.tar
Source2: graphviz-dot-x11-preview.desktop

Patch0:  graphviz-2.24.0-alt-perl-5.12.patch
Patch1:  graphviz-2.28.0-alt-string_h_trhow.patch
Patch2:  graphviz-2.38.0-gs-9.18-fix.patch
Patch3:  graphviz-2.41.2-alt-add-riscv64.patch
Patch4:  graphviz-9.0.0-loongarch64.patch
Patch5:  graphviz-11.0.0-alt-redefinition.patch

# From Fedora:
Patch40:                 graphviz-2.40.1-visio.patch
Patch41:                 graphviz-2.40.1-python3.patch
# https://gitlab.com/graphviz/graphviz/issues/1367
Patch42:                 graphviz-2.40.1-CVE-2018-10196.patch
# rhbz#1505230
Patch43:                 graphviz-2.40.1-dotty-menu-fix.patch
Patch44:                 graphviz-2.40.1-coverity-scan-fixes.patch

Requires: lib%name = %version-%release
Provides: libdotneato = %version
Obsoletes: libdotneato < %version

BuildRequires: flex gcc-c++ groff-base imake libXaw-devel libXpm-devel libann-devel libexpat-devel libgd2-devel swig tk-devel xorg-cf-files libltdl-devel qpdf libgs-devel ghostscript
BuildRequires: groff-ps

%{?!_with_bootstrap:BuildRequires: ghostscript-utils libfreeglut-devel libglade-devel libgs-devel libgtkglext-devel libgts-devel liblasi-devel librsvg-devel}
%{?_enable_lua:BuildRequires: liblua5-devel}
%{?_enable_guile:BuildRequires: guile22-devel}
%{?_with_devil:BuildRequires: libdevil-devel}
%if_enabled python3
BuildRequires(pre): rpm-build-python3 python3-devel
%add_python3_path %gvlibdir/python3/
%endif

%set_verify_elf_method unresolved=relaxed
%add_findreq_skiplist %gvdatadir/demo/*.pl
%add_findreq_skiplist %gvdatadir/demo/*.tcl
%add_findreq_skiplist %_bindir/vimdot

%description
Graphviz is a set of graph drawing tools originally developed
at AT&T Research.

Graph drawing addresses the problem of visualizing structural
information by constructing geometric representations of abstract
graphs and networks.  Automatic generation of graph drawings has
important applications in key technologies such as database
design, software engineering, VLSI and network design and visual
interfaces in other domains.

# {{{ subpackages
%package -n lib%name
Summary: Shared libraries for %name
Group: System/Libraries

%description -n lib%name
This package includes shared libraries for %name

%package -n lib%name-devel
Summary: Header files and C programming manual for %name
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%description -n lib%name-devel
This package includes header files for %name

%package doc
Summary: Documentation for %name
Group: Publishing
Requires: %name = %version-%release
BuildArch: noarch

%description doc
This package contains most of documentation for %name

%package graphs
Summary: Demo graphs for graphviz
Group: Graphics
Requires: %name = %version-%release
BuildArch: noarch

%description graphs
This package provides some example graphs for %name.

%package guile
Summary: Guile bindings to %name
Group: Development/Other
Requires: %name = %version-%release

%description guile
This package makes %name functionality accessible from Guile

%package lua
Summary: Lua bindings to %name
Group: Development/Other
Requires: %name = %version-%release

%description lua
This package makes %name functionality accessible from Lua

%package perl
Summary: Perl bindings to %name
Group: Development/Perl
Requires: %name = %version-%release

%description perl
This package makes %name functionality accessible from Perl

%package -n python3-module-gv
Summary: Python bindings to %name
Group: Development/Python
Requires: %name = %version-%release

%description -n python3-module-gv
This package makes %name functionality accessible from Python

%package ruby
Summary: Ruby bindings to %name
Group: Development/Ruby
Requires: %name = %version-%release

%description ruby
This package makes %name functionality accessible from Ruby

%package tcl
Summary: Tcl bindings to %name
Group: Development/Tcl
Requires: %name = %version-%release
Requires: tcl >= 8.4.0-alt1
Provides: tcl-tkspline = %version tcl-gd = %version
Obsoletes: tcl-tkspline < %version tcl-gd < %version

%description tcl
This package makes %name functionality accessible from Tcl

# }}}

%prep
%setup
%patch0 -p1
#patch1
%patch2 -p1
#patch3 -p1
%patch4 -p1
%patch5 -p1

#patch40 -p1 -b .visio
#patch41 -p1 -b .python3
#patch42 -p1 -b .CVE-2018-10196
#patch43 -p1 -b .dotty-menu-fix
#patch44 -p1 -b .coverity-scan-fixes

# XXX Hack out #!/usr/bin/lua
for N in tclpkg/gv/demo/*lua; do
	sed -i 's@#!/usr/bin/lua@#!/usr/bin/env lua@' $N
done

#ifarch %e2k
# 2.41 got hardwired arch list for libsuffix there :-/
#sed -i 's,sparc64,& | e2k,' configure.ac
#endif

%build
%add_optflags -DNDEBUG

# skip internal libltdl
rm -rf libltdl/ m4/ltdl.m4
subst 's|^LT_INIT(|dnl LT_INIT(|' configure.ac
subst 's|^LT_CONF|dnl LT_CONF|' configure.ac
subst 's|^LTDL|dnl LTDL|' configure.ac
export LIBLTDL=-lltdl

# http://lists.gnu.org/archive/html/libtool/2008-10/msg00010.html
%autoreconf --no-recursive
%configure \
	--disable-static \
	--with-pangocairo \
	--with-x \
	--with-gdk-pixbuf \
	--without-gnomeui \
	--with-gtk \
	--without-qt \
	--with-ipsepcola \
	--with-sfdp \
	--with-smyrna \
	--enable-lefty \
	%{subst_enable guile } \
	%{subst_enable lua } \
	%{subst_enable ocaml } \
	%{subst_enable php } \
	%{subst_enable python2 } \
	%{subst_enable python3 } \
	%{subst_enable ruby } \
	%{subst_enable tcl } \
	--disable-python \
	--disable-java \
	--disable-sharp
#	%{subst_enable guile } \
#make_build 


make %{?_smp_mflags} CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing -fno-strict-overflow %{?FFSTORE}" \
  CXXFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing -fno-strict-overflow %{?FFSTORE}"


%install

%makeinstall_std DESTDIR=%{buildroot} \
    docdir=%{_docdir}/%{name}-%version \
    LUA_INSTALL_DIR=%lua_modulesdir

# Remove metadata from generated PDFs
pushd %buildroot%_defaultdocdir/%name-%version
for f in prune lneato.1 lefty.1 gvgen.1 gc.1 dotty.1 dot.1 cluster.1
do
  if [ -f $f.pdf ]
  then
# ugly, but there is probably no better solution
    qpdf --empty --static-id --pages $f.pdf -- $f.pdf.$$
    mv -f $f.pdf.$$ $f.pdf
  fi
done
popd

%if_enabled tcl
# argh, #21967
if [ ! -d %buildroot%gvtcldir ]; then
	mkdir -p "$(dirname %buildroot%gvtcldir)"
	mv %buildroot{%_libdir/%name/tcl,%gvtcldir} ||:
fi
%endif

install -m0644 -D %SOURCE2 %buildroot%_desktopdir/graphviz-dot-x11-preview.desktop

# created by %%_bindir/dot -c
touch %buildroot%gvlibdir/config

find %buildroot/%_libexecdir -name \*.la -delete
find %buildroot/%_libdir -name \*.la -delete
rm -fv %buildroot%_datadir/graphviz/demo/modgraph.py

# Dereference manual symlinks
mv %buildroot%_man1dir/* %buildroot%_man3dir/
cp -aL %buildroot%_man3dir/*.1 %buildroot%_man1dir/
rm -f %buildroot%_man3dir/*.1

# Removing useless python3-modules (their copies are under std-path)
rm -rf %buildroot%gvlibdir/python3/

%post
[ ! -x %_bindir/dot ] || %_bindir/dot -c >&/dev/null

%files
%_bindir/*
%_desktopdir/*.desktop
%dir %gvdatadir/
%gvdatadir/gvpr
%if_without bootstrap
%gvdatadir/smyrna
%endif
%ghost %gvlibdir/config
%_man1dir/*
%_man7dir/*

%files -n lib%name
%_libdir/lib*.so.*
%dir %gvlibdir/
%gvlibdir/lib*.so.*
%gvlibdir/libgvplugin_*.so

%files -n lib%name-devel
%_includedir/%name
%_libdir/lib*.so
%_libdir/pkgconfig/*.pc
%_man3dir/*
%exclude %_man3dir/*tcl*

%files doc
%_defaultdocdir/%name-%version/

%{?!_with_bootstrap:%gvdatadir/examples}

%files graphs
%gvdatadir/graphs

%if_enabled guile
%files guile
%dir %gvlibdir/guile/
%gvlibdir/guile/*.so
%endif

%if_enabled lua
%files lua
%dir %gvlibdir/lua/
%gvlibdir/lua/*.so
%lua_modulesdir/gv.so
%gvdatadir/demo/modgraph.lua
%endif

%files perl
%dir %gvlibdir/perl/
%gvlibdir/perl/gv.pm
%gvlibdir/perl/gv.so
%gvlibdir/perl/libgv_perl.so
%perl_vendor_archlib/gv.pm
%perl_vendor_archlib/gv.so
%gvdatadir/demo/modgraph.pl

%if_enabled python3
%files -n python3-module-gv
%python3_sitelibdir/*
%endif

%if_enabled ruby
%files ruby
%dir %gvlibdir/ruby/
%gvlibdir/ruby/gv.so
%endif

%if_enabled tcl
%files tcl
%dir %gvtcldir/
%gvtcldir/lib*tcl*.so*
%gvtcldir/*.tcl
%_libdir/tcl*/*
%gvdatadir/demo/*.tcl
%gvdatadir/demo/pathplan*
%gvdatadir/demo/*.README
%gvdatadir/demo/*.html
%_man3dir/*tcl*
%endif

# TODO:
# - enable/fix/test language bindings

%changelog
