Name: grep
Version: 3.11.0.20.dd8f
Release: alt1

Summary: The GNU versions of grep pattern matching utilities
License: GPLv3+
Group: File tools
Url: https://www.gnu.org/software/grep/

%define srcname %name-%version-%release
# https://git.altlinux.org/people/glebfm/packages/grep.git refs/heads/grep-current
Source0: %srcname.tar
# https://git.altlinux.org/people/glebfm/packages/grep.git refs/heads/po-current
Source1: po-%version-%release.tar

Source3: GREP_COLORS
Source4: color_grep.sh
Source5: color_grep.csh

# https://git.altlinux.org/people/glebfm/packages/grep.git grep-current..grep-alt
Patch: %name-%version-%release.patch

Provides: pcre-grep, pgrep
Obsoletes: pcre-grep, pgrep

BuildRequires: makeinfo, gnulib >= 0.1.6720.7b430
# due to build from git
BuildRequires: gperf
# due to --perl-regexp
BuildRequires: libpcre2-devel

%description
The GNU versions of commonly used grep utilities.  grep searches through
textual input for lines which contain a match to a specified pattern
and then prints the matching lines.  GNU's grep utilities include grep,
egrep, fgrep, and pcregrep.

%prep
%setup -n %srcname -a1
%patch -p1

# Build scripts expect to find the grep version in this file.
echo -n %version > .tarball-version

# Generate LINGUAS file.
ls po/*.po | sed 's|.*/||; s|\.po$||' > po/LINGUAS

# git, texi2pdf, and wget aren't needed for build.
sed -E '/^(git|texi2pdf|wget)[[:space:]]/d' -i bootstrap.conf

%build
./bootstrap --skip-po --gnulib-srcdir=%_datadir/gnulib

# Unset the variable gl_printf_safe to indicate that we do not need
# a safe handling of non-IEEE-754 'long double' values.
sed -i 's/gl_printf_safe=yes/gl_printf_safe=/' m4/gnulib-comp.m4 configure

%if "%_pointer_size" == "32"
# Disable -fanalyzer to fix FTBFS on 32-bit platforms, see
# https://gcc.gnu.org/bugzilla/show_bug.cgi?id=103602
export gl_cv_warn_c__fanalyzer=no
%endif

%configure \
	--bindir=/bin \
	--disable-silent-rules \
	--enable-gcc-warnings \
	#
%make_build

%install
%makeinstall_std bindir=/bin

# Re-introduce symlinks for egrep and fgrep manpages.
ln -s grep.1 %buildroot%_man1dir/egrep.1
ln -s grep.1 %buildroot%_man1dir/fgrep.1

# Move deprecated egrep and fgrep from /bin/ to %_bindir/.
mkdir -p %buildroot%_bindir
mv %buildroot/bin/{e,f}grep %buildroot%_bindir/

# Provide pcregrep for backwards compatibility.
cp -a %buildroot%_bindir/egrep %buildroot%_bindir/pcregrep
sed 's/-E/-P/g' < %buildroot%_bindir/egrep > %buildroot%_bindir/pcregrep
ln -s grep.1 %buildroot%_man1dir/pcregrep.1

mkdir -p %buildroot%_sysconfdir/profile.d
install -pm755 %_sourcedir/color_grep.{sh,csh} \
	%buildroot%_sysconfdir/profile.d/
install -pm644 %_sourcedir/GREP_COLORS \
	%buildroot%_sysconfdir/

%find_lang %name

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%check
# pcre-jitstack needs more stack space
ulimit -s 32768
%make_build -k check

%files -f %name.lang
%config(noreplace) %_sysconfdir/GREP_COLORS
%config(noreplace) %_sysconfdir/profile.d/*
/bin/grep
%_bindir/egrep
%_bindir/fgrep
%_bindir/pcregrep
%_mandir/man?/*
%_infodir/*.info*
%doc AUTHORS NEWS README TODO

%changelog
