%def_disable snapshot

%def_enable aom
%def_enable ladspa
%def_enable libdc1394
%def_enable libkate
%def_enable mjpegtools
%def_enable opencv
%def_enable timidity
%def_enable vulkan
%def_enable wayland
%def_enable zbar
%def_enable zxing
%def_enable faad
%def_enable faac
%def_enable fdkaac
%def_enable lc3
%def_enable srtp
%def_enable srt
%def_disable rtmp
%def_enable openh264
%def_enable chromaprint
%def_enable v4l2codecs
%def_enable gpl

%ifnarch aarch64 loongarch64 riscv64
%def_enable svtjpegxs
%endif

%ifnarch %e2k
%def_enable liblilv
%endif

%def_disable debug
%def_enable tests
# required network
%def_disable gst_player_tests
%def_disable check

%define _name gst-plugins
%define api_ver 1.0
%define ver_major 1.26

%define _gst_libdir %_libdir/gstreamer-%api_ver

%def_disable doc

Name: %_name-bad%api_ver
Version: %ver_major.4
Release: alt1

Summary: A set of GStreamer plugins that need more quality
Group: System/Libraries
License: LGPLv2+
Url: http://gstreamer.freedesktop.org/

%if_disabled snapshot
Source: http://gstreamer.freedesktop.org/src/%_name-bad/%_name-bad-%version.tar.xz
%else
Source: %_name-bad-%version.tar
%endif

Provides: %_name-bad = %EVR

Obsoletes: gst-transcoder < 1.17
Provides: gst-transcoder = %EVR

Requires: lib%_name%api_ver >= %ver_major
Requires: gstreamer%api_ver >= %ver_major

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson gcc-c++ 
BuildRequires: gst-plugins%api_ver-devel >= %version gst-plugins%api_ver-gir-devel
BuildRequires: bzlib-devel libSDL-devel libX11-devel
BuildRequires: libalsa-devel libcdaudio-devel libdca-devel libdirac-devel libdvdnav-devel libexif-devel
BuildRequires: libgio-devel libgsm-devel libjasper-devel libmms-devel libzvbi-devel
%{?_enable_mjpegtools:BuildRequires: libmjpegtools-devel}
BuildRequires: libmpcdec-devel libneon-devel liboil-devel libsoundtouch-devel libssl-devel libmodplug-devel
BuildRequires: libcelt-devel libxvid-devel
%{?_enable_timidity:BuildRequires: libtimidity-devel timidity-instruments}
%{?_enable_libkate:BuildRequires: libkate-devel libtiger-devel}
%{?_enable_libdc1394:BuildRequires: libdc1394-devel}
BuildRequires: libvpx-devel liborc-devel orc libofa-devel libmusicbrainz-devel libass-devel
%{?_enable_wayland:BuildRequires: libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel wayland-protocols}
%{?_enable_zbar:BuildRequires: libzbar-devel}
%{?_enable_zxing:BuildRequires: pkgconfig(zxing)}
BuildRequires: libEGL-devel libwebp-devel libopenjpeg2.0-devel libbluez-devel
BuildRequires: libsoup-devel libfreeaptx-devel
BuildRequires: libdbus-devel libxml2-devel libgnutls-devel libvdpau-devel
BuildRequires: libsbc-devel libusb-devel libgudev-devel libopus-devel
BuildRequires: libcurl-devel libssh2-devel
BuildRequires: libvo-amrwbenc-devel librsvg-devel libvo-aacenc-devel libgcrypt-devel
BuildRequires: gobject-introspection-devel libgstreamer1.0-gir-devel
BuildRequires: libvisual0.4-devel openexr-devel libx265-devel
BuildRequires: libclutter-devel
BuildRequires: libbs2b-devel
BuildRequires: libopenal-devel
BuildRequires: flite-devel
%{?_enable_srtp:BuildRequires: libsrtp2-devel >= 2.1.0}
%{?_enable_srt:BuildRequires: libsrt-devel >= 1.3.0}
#BuildRequires: pkgconfig(wpe-webkit-1.0) pkgconfig(wpebackend-fdo-1.0)
BuildRequires: liborc-test-devel gstreamer1.0-utils
%{?_enable_faad:BuildRequires: libfaad-devel}
%{?_enable_faac:BuildRequires: libfaac-devel}
%{?_enable_lc3:BuildRequires: pkgconfig(lc3)}
%{?_enable_openh264:BuildRequires: libopenh264-devel >= 1.3.0}
%{?_enable_opencv:BuildRequires: libopencv-devel}
%{?_enable_aom:BuildRequires: libaom-devel}
%{?_enable_ladspa:BuildRequires: ladspa_sdk liblrdf-devel libfluidsynth-devel}
%{?_enable_vulkan:BuildRequires: vulkan-devel glslc glslang}
%{?_enable_rtmp:BuildRequires: librtmp-devel}
%{?_enable_chromaprint:BuildRequires: libchromaprint-devel}
%{?_enable_fdkaac:BuildRequires: pkgconfig(fdk-aac)}
%{?_enable_v4l2codecs:BuildRequires: glibc-kernheaders pkgconfig(gudev-1.0)}
# webrtc-audio-processing for webrtcdsp
BuildRequires: libwebrtc-devel >= 0.3 pkgconfig(webrtc-audio-processing-1) pkgconfig(webrtc-audio-processing-2) >= 1.0
# since 1.13.x
BuildRequires: libnice-devel libva-devel liblcms2-devel
%{?_enable_liblilv:BuildRequires: liblilv-devel}
%{?_enable_svtjpegxs:BuildRequires: pkgconfig(SvtJpegxs)}
%{?_enable_doc:BuildRequires: hotdoc gstreamer%api_ver-utils}
%{?_enable_check: BuildRequires: /proc %_bindir/gst-tester-%api_ver}
#BuildRequires: pkgconfig(svtav1enc) 1.8 too old
#BuildRequires: pkgconfig(spandsp)

%description
GStreamer Bad Plug-ins is a set of plug-ins that aren't up to par
compared to the rest.  They might be close to being good quality, but
they're missing something - be it a good code review, some
documentation, a set of tests, a real live maintainer, or some actual
wide use.  If the blanks are filled in they might be upgraded to
become part of either gst-plugins-good or gst-plugins-ugly, depending
on the other factors.

%package devel
Summary: Development files for GStreamer Bad Plug-ins
Group: Development/C
Provides: %_name-bad-devel = %EVR
Requires: %name = %EVR
Obsoletes: gst-transcoder-devel < 1.17
Provides: gst-transcoder-devel = %EVR

%description devel
This package contains the libraries, headers and other files necessary
to develop GStreamer Bad Plug-ins.

%package doc
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch
Provides: %_name-bad-doc = %EVR
Obsoletes: gst-transcoder-devel-doc < 1.17
Provides: gst-transcoder-devel-doc = %EVR

%description doc
This package contains documentation for GStreamer Bad Plug-ins.

%prep
%setup -n %_name-bad-%version

%build
%meson \
	%{?_enable_gpl:-Dgpl=enabled} \
	-Dexamples=disabled \
	%{?_enable_check:-Dtests=enabled} \
	%{?_disable_doc:-Ddoc=disabled} \
	%{?_enable_debug:-Dgst_debug=true}
%nil
%meson_build

%install
%meson_install
%find_lang %_name-bad-%api_ver

%files -f %_name-bad-%api_ver.lang
%_bindir/gst-transcoder-%api_ver
%_libdir/*.so.*
%dir %_gst_libdir
%_gst_libdir/*.so
%_typelibdir/GstBadAudio-%api_ver.typelib
%_typelibdir/GstCodecs-%api_ver.typelib
%_typelibdir/GstInsertBin-%api_ver.typelib
%_typelibdir/GstMpegts-%api_ver.typelib
%_typelibdir/GstPlayer-%api_ver.typelib
%_typelibdir/GstPlay-%api_ver.typelib
%_typelibdir/GstTranscoder-%api_ver.typelib
%_typelibdir/GstWebRTC-%api_ver.typelib
%_typelibdir/GstCuda-%api_ver.typelib
%_typelibdir/CudaGst-%api_ver.typelib
%_typelibdir/GstVa-%api_ver.typelib
%_typelibdir/GstVulkan-%api_ver.typelib
%_typelibdir/GstVulkanWayland-%api_ver.typelib
%_typelibdir/GstAnalytics-1.0.typelib
%_typelibdir/GstDxva-1.0.typelib
%_typelibdir/GstMse-1.0.typelib
%_datadir/gstreamer-%api_ver/presets/GstVoAmrwbEnc.prs
%_datadir/gstreamer-%api_ver/presets/GstFreeverb.prs
%_datadir/gstreamer-%api_ver/encoding-profiles/device/dvd.gep
%_datadir/gstreamer-%api_ver/encoding-profiles/file-extension/avi.gep
%_datadir/gstreamer-%api_ver/encoding-profiles/file-extension/flv.gep
%_datadir/gstreamer-%api_ver/encoding-profiles/file-extension/mkv.gep
%_datadir/gstreamer-%api_ver/encoding-profiles/file-extension/mp3.gep
%_datadir/gstreamer-%api_ver/encoding-profiles/file-extension/mp4.gep
%_datadir/gstreamer-%api_ver/encoding-profiles/file-extension/oga.gep
%_datadir/gstreamer-%api_ver/encoding-profiles/file-extension/ogv.gep
%_datadir/gstreamer-%api_ver/encoding-profiles/file-extension/webm.gep
%_datadir/gstreamer-%api_ver/encoding-profiles/online-services/youtube.gep
%_datadir/gstreamer-%api_ver/encoding-profiles/file-extension/ts.gep
%doc AUTHORS NEWS README* RELEASE

%files devel
%_includedir/gstreamer-%api_ver/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_girdir/GstInsertBin-%api_ver.gir
%_girdir/GstMpegts-%api_ver.gir
%_girdir/GstPlayer-%api_ver.gir
%_girdir/GstWebRTC-%api_ver.gir
%_girdir/GstBadAudio-%api_ver.gir
%_girdir/GstCodecs-%api_ver.gir
%_girdir/GstTranscoder-%api_ver.gir
%_girdir/GstPlay-%api_ver.gir
%_girdir/CudaGst-%api_ver.gir
%_girdir/GstCuda-%api_ver.gir
%_girdir/GstVa-%api_ver.gir
%_girdir/GstVulkan-%api_ver.gir
%_girdir/GstVulkanWayland-%api_ver.gir
%_girdir/GstAnalytics-1.0.gir
%_girdir/GstDxva-1.0.gir
%_girdir/GstMse-1.0.gir

%if_enabled doc
%files doc
%_gtk_docdir/gst-plugins-bad-plugins-%api_ver
%_gtk_docdir/gst-plugins-bad-libs-%api_ver
%endif

%changelog
