%define _name gstreamer
%define ver_major 1.26
%define api_ver 1.0
%define _libexecdir %_prefix/libexec
%define api_ver 1.0

%def_disable doc
%def_disable debug
%def_disable libunwind
%def_disable libdw
%ifarch %e2k
%def_disable ptp_helper
%else
%def_enable ptp_helper
%endif
%def_disable check

Name: %_name%api_ver
Version: %ver_major.4
Release: alt1

Summary: GStreamer streaming media framework runtime
License: LGPLv2+
Group: System/Libraries
Url: http://gstreamer.freedesktop.org

Source: http://gstreamer.freedesktop.org/src/%_name/%_name-%version.tar.xz

Provides: %_name = %EVR

Requires(pre): libcap-utils
Requires: lib%name = %EVR

%define glib_ver 2.64.0
%define meson_ver 1.4
%define rust_ver 1.54

BuildRequires(pre): rpm-macros-meson >= %meson_ver rpm-build-gir rpm-build-python3
BuildRequires: meson flex gcc-c++
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: ghostscript-utils libcheck-devel libxml2-devel
BuildRequires: sgml-common transfig xml-utils gobject-introspection-devel
BuildRequires: libgsl-devel libgmp-devel
BuildRequires: libcap-devel libcap-utils
BuildRequires: bash-completion
%{?_enable_libunwind:BuildRequires: libunwind-devel}
%{?_enable_libdw:BuildRequires: libdw-devel}
%{?_enable_ptp_helper:BuildRequires: rust-cargo >= %rust_ver}
%{?_enable_doc:BuildRequires: hotdoc}

%description
GStreamer is a streaming-media framework, based on graphs of filters which
operate on media data. Applications using this library can do anything
from real-time sound processing to playing videos, and just about anything
else media-related.  Its plugin-based architecture means that new data
types or processing capabilities can be added simply by installing new
plugins.

%package -n lib%name
Summary: Shared libraries of GStreamer
Group: System/Libraries
Provides: lib%_name = %EVR

%description -n lib%name
This package contains the shared libraries of the GStreamer media framework

%package -n lib%name-gir
Summary: GObject introspection data for the GStreamer library
Group: System/Libraries
Provides: lib%_name-gir = %EVR
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the GStreamer library

%package devel
Summary: Development files for GStreamer streaming-media framework
Group: Development/C
Provides: %_name-devel = %EVR
Requires: lib%name = %EVR

%description devel
This package contains the libraries and header files necessary to
develop applications and plugins for GStreamer

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GStreamer library
Group: System/Libraries
BuildArch: noarch
Provides: lib%_name-gir-devel = %EVR
Requires: lib%name-gir = %EVR %name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the GStreamer library

%package devel-doc
Summary: Development documentation for GStreamer
Group: Development/C
BuildArch: noarch
Provides: %_name-devel-doc = %EVR

%description devel-doc
This package contains development documentation for GStreamer

%package utils
Summary: GStreamer utilities
Group: System/Libraries
Provides: %_name-utils = %EVR
Requires: lib%name = %EVR

%description utils
This package contains some utilities used to register, analyze, and run
Gstreamer plugins.

%prep
%setup -n %_name-%version

%build
%ifarch %e2k
# till lcc ~1.23
export LIBS=-lcxa
%endif
%meson \
    -Dpackage-name="GStreamer" \
    -Dpackage-origin=%name \
    -Dexamples=disabled \
    %{?_enable_check:-Dtests=enabled} \
    %{?_disable_doc:-Ddoc=disabled} \
    %{?_enable_debug:-Dgst_debug=true} \
    %{subst_enable_meson_feature ptp_helper ptp-helper} \
    %{?_enable_ptp_helper:-Dptp-helper-permissions="capabilities"}
%nil
%meson_build

%install
%meson_install
%find_lang %_name-%api_ver

%check
%__meson_test

%post
setcap cap_sys_nice,cap_net_bind_service,cap_net_admin+ep %_libexecdir/%_name-%api_ver/gst-ptp-helper{,-test} 2>/dev/null ||:

%files -f %_name-%api_ver.lang
%dir %_libexecdir/%_name-%api_ver
%_libexecdir/%_name-%api_ver/gst-plugin-scanner
%{?_enable_ptp_helper:%_libexecdir/%_name-%api_ver/gst-ptp-helper}
#%_libexecdir/%_name-%api_ver/gst-ptp-helper-test
%dir %_libdir/%_name-%api_ver
%_libdir/%_name-%api_ver/*.so
%doc AUTHORS NEWS README* RELEASE

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-gir
%_typelibdir/Gst-%api_ver.typelib
%_typelibdir/GstBase-%api_ver.typelib
%_typelibdir/GstCheck-%api_ver.typelib
%_typelibdir/GstController-%api_ver.typelib
%_typelibdir/GstNet-%api_ver.typelib

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/aclocal/*
%_datadir/cmake/FindGStreamer.cmake
%if_enabled debug
%_datadir/gdb/auto-load/%_libdir/lib%name-%api_ver.so.*-gdb.py
%_datadir/glib-2.0/gdb/glib_gobject_helper.py
%_datadir/glib-2.0/gdb/gst_gdb.py
%endif

%files -n lib%name-gir-devel
%_girdir/Gst-%api_ver.gir
%_girdir/GstBase-%api_ver.gir
%_girdir/GstCheck-%api_ver.gir
%_girdir/GstController-%api_ver.gir
%_girdir/GstNet-%api_ver.gir

%if_enabled doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%files utils
%_bindir/gst-inspect-%api_ver
%_bindir/gst-launch-%api_ver
%_bindir/gst-stats-%api_ver
%_bindir/gst-tester-%api_ver
%_bindir/gst-typefind-%api_ver
%_man1dir/*
# bash-completions
%_libexecdir/%_name-%api_ver/gst-completion-helper
%_datadir/bash-completion/completions/gst-inspect-%api_ver
%_datadir/bash-completion/completions/gst-launch-%api_ver
%_datadir/bash-completion/helpers/gst
%_libexecdir/%_name-%api_ver/gst-hotdoc-plugins-scanner
%_libexecdir/%_name-%api_ver/gst-plugins-doc-cache-generator

%changelog
