%def_without gimp

%if_with gimp
%define _gimpplugindir %(gimptool-2.0 --gimpplugindir)/plug-ins/
%endif

Summary: A GTK front-end for gPhoto2
Name: gtkam
Version: 1.1
Release: alt2
License: GPLv2
Group: Graphics
Packager: Dmitriy Khanzhin <jinn@altlinux.org>

Source0: %name-%version.tar
Patch1: %name-%version-%release.patch

Url: http://www.gphoto.org

# Automatically added by buildreq on Tue Feb 11 2025
BuildRequires: libexif-gtk-devel libgphoto2-devel
%if_with gimp
BuildRequires: libgimp-devel
%endif
Requires: gtkam-i18n = %EVR

%description
The GTKam package provides a GTK-based front-end to gPhoto2.  Install
this package if you want to use a digital camera with Linux.

%if_with gimp
%package -n gimp-plugin-%name
Summary: GIMP plugin to open digital camera pictures
Group: Graphics
Requires: gtkam-i18n = %EVR gimp

%description -n gimp-plugin-%name
GIMP plugin that allows you to open pictures on a digital camera within GIMP.
%endif

%package -n %name-i18n
Summary: Languages support for GTKam
Group: Graphics
BuildArch: noarch

%description -n %name-i18n
Languages support for GTKam.

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure \
	%{subst_with gimp} \
	--without-gnome \
	--without-bonobo
%make_build

%install
%makeinstall

mkdir -p %buildroot%_liconsdir
mv %buildroot%_pixmapsdir/gtkam-camera.png %buildroot%_liconsdir/

%find_lang %name

%files
%_bindir/*
%_desktopdir/*
%_datadir/%name
%_datadir/gnome/*
%_datadir/omf/*
%_man1dir/*
%_liconsdir/*
%_pixmapsdir/*
%doc AUTHORS NEWS README TODO

%if_with gimp
%files -n gimp-plugin-%name
%_gimpplugindir/*
%endif

%files -n %name-i18n -f %name.lang

%changelog
