%define _unpackaged_files_terminate_build 1
%define ver 9

Name:    gz-sim
Version: %ver.0.0
Release: alt2

Summary: Open source robotics simulator. The latest version of Gazebo.
License: Apache-2.0
Group:   Other

Url:      https://github.com/gazebosim/gz-sim
Source:   %name-%version.tar
Packager: Andrey Cherepanov <cas@altlinux.org>

# Same as for ogre-next
ExclusiveArch: x86_64 %e2k

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: python3-dev
BuildRequires: libprotobuf-devel
BuildRequires: libfreeimage-devel
BuildRequires: libogre-next-devel
BuildRequires: libgperftools-devel
BuildRequires: libtinyxml2-devel
BuildRequires: tbb-devel
BuildRequires: libswscale-devel
BuildRequires: libavdevice-devel
BuildRequires: libavformat-devel
BuildRequires: libavfilter-devel
BuildRequires: libavcodec-devel
BuildRequires: libavutil-devel
BuildRequires: libgts-devel
BuildRequires: libbullet3-devel
BuildRequires: libusb-devel
BuildRequires: libopenal-devel
BuildRequires: libhdf5-devel
BuildRequires: libcurl-devel
BuildRequires: libswresample-devel
BuildRequires: libpcre2-devel
BuildRequires: libpostproc-devel
BuildRequires: protobuf-compiler
BuildRequires: tinyxml-devel
BuildRequires: libtar-devel

BuildRequires: gz-cmake
BuildRequires: libsdformat-devel
BuildRequires: libgz-msgs-devel
BuildRequires: libgz-transport-devel
BuildRequires: libgz-common-devel
BuildRequires: libgz-fuel-tools-devel
BuildRequires: libgz-plugin-devel
BuildRequires: libgz-sensors-devel
BuildRequires: libgz-gui-devel
BuildRequires: libgz-physics-devel
BuildRequires: gz-tools-devel
BuildRequires: libsimbody-devel
BuildRequires: qt5-base-devel
BuildRequires: qt5-quick1-devel
BuildRequires: qt5-quickcontrols2-devel
BuildRequires: libqwt6-qt5-devel
BuildRequires: boost-asio-devel
BuildRequires: boost-interprocess-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-program_options-devel
BuildRequires: libgdal-devel
BuildRequires: libuuid-devel
BuildRequires: pybind11-devel
BuildRequires: libyaml-devel
BuildRequires: libstdc++-devel-static
BuildRequires: ronn
BuildRequires: xsltproc
BuildRequires: libgraphviz-devel
%ifnarch %e2k
BuildRequires: libdart-devel
%endif
BuildRequires: libfmt-devel

# gz deps
Requires: gz-tools >= 2.0.0
Requires: libgz-sim = %EVR

%description
Gazebo simulates multiple robots in a 3D environment
with extensive dynamic interaction between objects.

%package -n lib%name
Summary: Library of %name
Group: System/Libraries

%description -n lib%name
%summary

%package -n lib%{name}-devel
Summary: Development files for %name
Group: Development/C++

%description -n lib%{name}-devel
%summary
%prep
%setup

%build
%add_optflags -I%_includedir/bullet
%cmake -GNinja -Wno-dev \
       -DQWT_WIN_INCLUDE_DIR=%_includedir/qt5
%ninja_build -C "%_cmake__builddir"

%install
%ninja_install -C "%_cmake__builddir"
install -Dpm0644 "%_cmake__builddir"/gz-sim%ver.desktop %buildroot%_desktopdir/gz-sim%ver.desktop
install -Dpm0644 "%_cmake__builddir"/gz-logo%ver.svg %buildroot%_pixmapsdir/gz-logo%ver.svg

%files
%doc AUTHORS README.md
%_datadir/gz/gz-sim%ver
%_desktopdir/*.desktop
%_pixmapsdir/*.svg

%files -n lib%name
%_libexecdir/ruby/*
%_libdir/lib*.so.*
%_libdir/lib*.so
%_libdir/gz-sim-%ver/plugins
%_libdir/python/gz
%_datadir/gz/model*.yaml
%_datadir/gz/gz2.completion.d/*.bash_completion.sh
%_datadir/gz/*.yaml

%files -n lib%{name}-devel
%_includedir/gz/*
%_cmakedir/*
%_pkgconfigdir/*.pc

%changelog
