Name: hasher-priv
Version: 2.0.14
Release: alt1

Summary: A privileged helper for the hasher project
License: GPLv2+
Group: Development/Other

Source: %name-%version.tar

%define _libexecdir %_prefix/libexec
%define helperdir %_libexecdir/%name
%define configdir %_sysconfdir/%name

Provides: %helperdir

# Due to makedev removal.
Conflicts: hasher < 1.4.0

BuildPreReq: help2man, sisyphus_check >= 0:0.7.11
BuildRequires: setproctitle-devel

%description
This package provides helpers for executing privileged operations
required by hasher utilities.

%prep
%setup

%build
%make_build CC="%__cc" CFLAGS="%optflags" libexecdir="%_libexecdir"

%install
%makeinstall_std \
	libexecdir="%_libexecdir" \
	tmpfilesdir="%_tmpfilesdir" \
	systemd_unitdir="%_unitdir" \
	#

%pre
groupadd -r -f hashman

%post
%post_service hasher-privd

%preun
%preun_service hasher-privd

%triggerpostun -- %name < 2.0
/sbin/chkconfig --add hasher-privd
if [ -n "$(getent group hashman |cut -d: -f4)" ]; then
	/sbin/chkconfig hasher-privd on
	/sbin/service hasher-privd start
fi

%files
%_sbindir/hasher-useradd
%_mandir/man?/*
# config
%attr(750,root,hashman) %dir %configdir
%attr(750,root,hashman) %dir %configdir/user.d
%attr(640,root,hashman) %config(noreplace) %configdir/fstab
%attr(640,root,hashman) %config(noreplace) %configdir/system
%attr(640,root,hashman) %config(noreplace) %configdir/daemon.conf
# helpers
%attr(750,root,hashman) %dir %helperdir
%attr(710,root,hashman) %helperdir/%name
%attr(755,root,root) %helperdir/*.sh
# daemon
%_sbindir/hasher-privd
%_unitdir/hasher-privd.service
%_initdir/hasher-privd
# socketdir
%_tmpfilesdir/%name.conf
%attr(710,root,hashman) %dir /run/%name/

%doc DESIGN

%changelog
