%def_with server
%ifarch %ix86
%define optflags_lto %nil
%endif

Name:       hedgewars
Version:    1.0.2
Release:    alt4

Summary:    Game with heavily armed fighting hedgehogs
Summary(ru_RU.UTF-8): Игра в битвы тяжело-вооружённых боевых ёжиков

License:    GPLv2
Group:      Games/Strategy
URL:        http://www.hedgewars.org/

Packager:   Grigory Ustinov <grenka@altlinux.org>

Source:     %name-%version.tar

%{?_with_server:
Source10:   vendor.tar
Source11:   hedgewars-server.cabal
}

Patch:      fix_non_inline_ShiftWorld.patch
# https://github.com/hedgewars/hw/pull/74
Patch2:     ffmpeg6.0-support.patch

Patch3:     hedgewars-1.0.2-fix_build_with_cmake_4.0.patch

%{?_with_server:
Patch10:    hedgewars-1.0.2-mtl_2.3.patch
}

Requires:   %name-data = %EVR
Requires:   fonts-ttf-wqy-zenhei fonts-ttf-dejavu

BuildRequires(pre): cmake
BuildRequires: fpc-units-gtk2 fpc-units-misc fpc-units-net
%{?_with_server:
BuildRequires: ghc cabal-install rpm-build-haskell-vendored
}
BuildRequires: libGLEW-devel libSDL2_image-devel libSDL2_mixer-devel
BuildRequires: libSDL2_net-devel libSDL2_ttf-devel libavformat-devel
BuildRequires: libffi-devel libfreeglut-devel libgmp-devel liblua5.1-compat-devel
BuildRequires: libphysfs-devel libqt5-quickshapes libpng-devel
BuildRequires: libswresample-devel qt5-tools-devel
BuildRequires: desktop-file-utils chrpath

ExclusiveArch: x86_64

%description
Each player controls a team of several hedgehogs. During the course of the
game, players take turns with one of their hedgehogs. They then use whatever
tools and weapons are available to attack and kill the opponents' hedgehogs,
thereby winning the game. Hedgehogs may move around the terrain in a variety
of ways, normally by walking and jumping but also by using particular tools
such as the "Rope" or "Parachute", to move to otherwise inaccessible areas.

Each turn is time-limited to ensure that players do not hold up the game
with excessive thinking or moving.
A large variety of tools and weapons are available for players during the
game: Grenade, Cluster Bomb, Bazooka, UFO, Shotgun, Desert Eagle, Minigun,
Baseball Bat, Dynamite, Mine, Rope, Pneumatic pick, Parachute, etc. Most weapons,
when used, cause explosions that deform the terrain, removing circular chunks.

The landscape is an island floating on a body of water, or a restricted cave
with water at the bottom. A hedgehog dies when it enters the water (either
by falling off the island, or through a hole in the bottom of it), it is
thrown off either side of the arena or when its health is reduced,
typically from contact with explosions, to zero (the damage dealt to the
attacked hedgehog or hedgehogs after a player's or CPU turn is shown only
when all movement on the battlefield has ceased).

%description -l ru_RU.UTF-8
Каждый игрок управляет командой из нескольких ёжиков. По ходу игры игроки делают
ходы одним из своих ёжиков. Они могут использовать всевозможные доступные
приспособления и оружие, чтобы атаковать и убивать ёжиков противника и таким
образом получить победу в игре. Ёжики могут передвигаться по локации множеством
способов, обычно с помощью ходьбы или прыжков, однако могут и использовать
различные приспособления, такие как верёвка или парашют, чтобы попасть в
труднодостижимые зоны.

Каждый ход ограничен по времени, чтобы гарантировать, что игроки не будут
задерживать игру излишними раздумьями или долгими передвижениями.
Во время игры игрокам доступен огромный ассортимент оружия и приспособлений:
гранаты, разрывные бомбы, базука, летающая тарелка, дробовик, пистолет,
пулемёт, бейсбольная бита, динамит, мина, верёвка, отбойный молоток, парашют,
всего не перечислить. Множество оружия при использовании вызывают взрывы,
которые разрушают локацию, выдирая из неё целые куски.

Локация представляет собой остров в воде или пещеру с водой внизу. Ёжик умрёт,
либо если зайдёт в воду или упадёт в неё с острова, либо если его здоровье
снизится до нуля от взрывов.

%package data
Summary: Resources for %name game
Summary(ru_RU.UTF-8): Файлы ресурсов для игры %name
Group:   Games/Strategy
BuildArch: noarch

%description data
This package contains all the data files for %name.
%description data -l ru_RU.UTF-8
Этот пакет содержит все файлы данных для игры %name.

%prep
%setup

%patch -p2
%patch2 -p1
%patch3 -p2

%{?_with_server:
%setup -D -T -a 10
cp %SOURCE11 gameServer
%patch10 -p1
}

# Make sure that we don't use bundled libraries
rm -r misc/liblua

%build
%add_optflags -fcommon
%remove_optflags -frecord-gcc-switches
%cmake_insource -G'Unix Makefiles' -DPHYSFS_SYSTEM=1 \
%_cmake_skip_rpath \
-DDATA_INSTALL_DIR=%_datadir/%name -Dtarget_library_install_dir="%_libdir" \
-DFONTS_DIRS="/usr/share/fonts/ttf/wqy-zenhei;/usr/share/fonts/ttf/dejavu" \
-DNOSERVER=1

%make_build VERBOSE=true

%{?_with_server:
%cabal_vendor_build --project-dir gameServer exe:hedgewars-server
}

%install
%makeinstall_std

%{?_with_server:
%cabal_vendor_install --project-dir gameServer exe:hedgewars-server
}

# below is the desktop file and icon stuff.
mkdir -p %buildroot%_datadir/applications
desktop-file-install \
  --dir %buildroot%_datadir/applications \
  %buildroot%_datadir/hedgewars/Data/misc/hedgewars.desktop
mkdir -p %buildroot%_datadir/icons/hicolor/32x32/apps
install -p -m 644 misc/hedgewars_ico.png \
  %buildroot%_datadir/icons/hicolor/32x32/apps/hedgewars.png
mkdir -p %buildroot%_datadir/icons/hicolor/512x512/apps
install -p -m 644 misc/hedgewars.png \
  %buildroot%_datadir/icons/hicolor/512x512/apps/%name.png

# fix verify-elf's RPATH error
chrpath --delete %buildroot%_bindir/hwengine

%files
%doc README ChangeLog.txt CREDITS
%_bindir/*
%_libdir/*.so.*
%_libdir/libavwrapper.so
%_libdir/libphyslayer.so
%_datadir/applications/%name.desktop
%_datadir/icons/hicolor/32x32/apps/%name.png
%dir %_datadir/icons/hicolor/512x512
%dir %_datadir/icons/hicolor/512x512/apps
%_datadir/icons/hicolor/512x512/apps/%name.png
%_datadir/appdata/%name.appdata.xml
%_pixmapsdir/%name.xpm

%files data
%_datadir/%name

%changelog
