%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define sover 1

%def_with devel

%if_with devel
%define _unpackaged_files_terminate_build 1

Name: hiredis
%else
Name: hiredis%sover
%endif
Version: 1.2.0
Release: alt2
Summary: The official C client for Redis
Group: System/Libraries
License: BSD-3-Clause
Url: https://github.com/redis/hiredis
Source: hiredis-%version.tar

Patch1: hiredis-alt-no-static-libraries.patch

BuildRequires: gcc-c++ libevent-devel libev-devel glib2-devel

%description
Hiredis is a minimalistic C client library for the Redis database.

%package -n libhiredis%sover
Summary: The official C client for Redis
License: BSD
Group: System/Libraries
Obsoletes: libhiredis1.1.0
Conflicts: libhiredist1.1.0

%description -n libhiredis%sover
Hiredis is a minimalistic C client library for the Redis database.

%if_with devel
%package -n libhiredis-devel
Summary: Header files and libraries for hiredis C development
Group: Development/C
Requires: libhiredis%sover = %EVR

Provides: hiredis-devel = %EVR
Obsoletes: hiredis-devel

# Those pkgs included the example & test executables, too:
Conflicts: libhiredis0.12 <= 0.12-alt1
Conflicts: libhiredis <= 0.12-alt1
Conflicts: libhiredis0.11
Conflicts: libhiredis0.10

%description -n libhiredis-devel
The hiredis-devel package contains the header files and
libraries to develop applications using a Redis database.
%endif

%prep
%setup -n hiredis-%version

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%make_build \
	OPTIMIZATION= \
	DEBUG_FLAGS= \
	CFLAGS="%optflags" \
	CXXFLAGS="%optflags" \
	%nil

%make examples \
	OPTIMIZATION= \
	DEBUG_FLAGS= \
	CFLAGS="%optflags" \
	CXXFLAGS="%optflags" \
	%nil

%make hiredis-test \
	OPTIMIZATION= \
	DEBUG_FLAGS= \
	CFLAGS="%optflags" \
	CXXFLAGS="%optflags" \
	%nil

%install
%make install \
	PREFIX=%buildroot%_prefix \
	LIBRARY_PATH=%_lib \
	LIB_SUFFIX=%_libsuff \
	%nil
find %buildroot -name '*.a' -delete -print
mkdir -p %buildroot%_bindir/
cp examples/hiredis-example* %buildroot%_bindir/
cp hiredis-test %buildroot%_bindir/

%files -n libhiredis%sover
%doc COPYING CHANGELOG.md
%_libdir/*.so.%{sover}
%_libdir/*.so.%{sover}.*

%if_with devel
%files -n libhiredis-devel
%doc README.md
%_bindir/hiredis-example*
%_bindir/hiredis-test
%_includedir/hiredis
%_libdir/*.so
%_libdir/pkgconfig/hiredis.pc
%endif

%changelog
