%define _unpackaged_files_terminate_build 1
%define pypi_name httpie

%def_with check

Name: httpie
Version: 3.2.4
Release: alt5

Summary: HTTPie: modern, user-friendly command-line HTTP client for the API era
Group: Networking/WWW
License: BSD
Url: https://httpie.io/cli
VCS: https://github.com/httpie/cli.git
BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%add_pyproject_deps_runtime_filter pip
%add_pyproject_deps_runtime_filter setuptools
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra test
%endif

%description
HTTPie is a CLI HTTP utility built out of frustration with existing tools. The
goal is to make CLI interaction with HTTP-based services as human-friendly as
possible.

HTTPie does so by providing an http command that allows for issuing arbitrary
HTTP requests using a simple and natural syntax and displaying colorized
responses.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
##https://github.com/httpie/cli/issues/1276#issuecomment-1019441082
%pyproject_run_pytest -m "not requires_installation"

%files
%_bindir/http
%_bindir/httpie
%_bindir/https
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%_man1dir/http.1*
%_man1dir/https.1*
%_man1dir/httpie.1*
%doc LICENSE README.md

%changelog
