Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: /usr/bin/desktop-file-install unzip
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           imagej
Version:        1.54c
Release:        alt1_1jpp11
Summary:        Image Processing and Analysis in Java

# From https://imagej.nih.gov/ij/disclaimer.html:
#   ImageJ was developed at the National Institutes of Health by an employee of
#   the Federal Government in the course of his official duties. Pursuant to
#   Title 17, Section 105 of the United States Code, this software is not
#   subject to copyright protection and is in the public domain. ImageJ is an
#   experimental system. NIH assumes no responsibility whatsoever for its use
#   by other parties, and makes no guarantees, expressed or implied, about its
#   quality, reliability, or any other characteristic.
# https://gitlab.com/fedora/legal/fedora-license-data/-/commit/b216f9bcb1c3195b4ddb14674d95e299f669903a
License:        LicenseRef-Fedora-Public-Domain
URL:            https://imagej.net/ij/index.html
Source0:        https://imagej.net/ij/download/src/ij%(echo '%{version}' | tr -d .)-src.zip
Source1:        imagej.desktop
Source2:        https://rsbweb.nih.gov/ij/macros/macros.zip
Source3:        https://rsb.info.nih.gov/ij/download/linux/unix-script.txt
Source4:        imagej.png

BuildArch:      noarch

# Do not copy class files.
Patch0:          imagej-1.53r-do-not-copy-class-files.patch
# Modify imagej.sh (as intended by upstream) for Fedora compatibility.
Patch1:          imagej-1.53r-unix-script.patch
# Set javac source / target version to 1.8 to fix building with Java 11.
Patch2:          imagej-1.53r-source-target-version.patch

BuildRequires:  ant
BuildRequires:  desktop-file-utils

BuildRequires:  jpackage-utils

Requires:       jpackage-utils
# Require java-devel, not only java, for plugins build

# We no longer package javadoc documentation because it has guidelines issues
# pertaining to bundled and pre-minified JavaScript and CSS.  See
# https://bugzilla.redhat.com/show_bug.cgi?id=2006555 and the linked
# a.'packaginga.' mailing list discussion for similar issues in documentation
# generated by Sphinx and Doxygen.
Obsoletes:      imagej-javadoc < 1.53r-1
Source44: import.info

%description
ImageJ is a public domain Java image processing program. It can display, edit,
analyze a wide variety of image data, including image sequences. Imagej can be
used for quantitative analysis of engineering and scientific image data.


%prep
%setup -q -c

unzip -qq -u '%{SOURCE2}'
cp -p '%{SOURCE3}' ./imagej.sh

# Erase binary and useless files
rm -rvf macros/.FBC* macros/build.xml __MACOSX
# Strip out any bundled pre-compiled class or jar files:
find . \( -name '*.class' -o -name '*.jar' \) -print -delete
# Fix permissions
find macros -type d -exec chmod -v 0755 '{}' '+'
find macros -type f -exec chmod -v 0644 '{}' '+'

%patch0 -p1
%patch1 -p1
%patch2 -p1

# Replace placeholders in our patched unix-script.txt/imagej.sh.
sed -r -i \
    -e 's#@JAVADIR@#%{_javadir}#' \
    -e 's#@PKGDATADIR@#%{_datadir}/imagej#' \
    imagej.sh

# Make sure the upstream version number is set correctly, and use the initial
# numeric <pkgrel> field of the Release as the BUILD.
%global pkgrel %(echo '%{release}' | sed -r 's/[^[:digit:]].*$//')
sed -r -i \
    -e 's/(public static final String VERSION = )"[^"]+";/\1"%{version}";/' \
    -e 's/(public static final String BUILD = )"[^"]+";/\1"%{pkgrel}";/' \
    source/ij/ImageJ.java


%build
cd source
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  build
cd ..


%install
# install jar
install -p -m 0644 -D source/ij.jar '%{buildroot}%{_javadir}/imagej.jar'

# install icon
install -D -p -m 0644 -t '%{buildroot}%{_datadir}/pixmaps' '%{SOURCE4}'

# install data files and macros
install -D -p -m 0644 -t '%{buildroot}%{_datadir}/imagej' \
    source/build/about.jpg source/build/IJ_Props.txt
cp -rvp macros '%{buildroot}%{_datadir}/imagej/'

# install directories for luts and plugins
install -d '%{buildroot}%{_datadir}/imagej/luts' \
    '%{buildroot}%{_datadir}/imagej/plugins'
# install -p -m 0644 source/plugins/JavaScriptEvaluator.source \
#    '%%{buildroot}%%{_datadir}/imagej/plugins/JavaScriptEvaluator.java'

# install script
install -D -p imagej.sh '%{buildroot}%{_bindir}/imagej'

# desktop file
desktop-file-install --vendor=''                     \
       --dir=%{buildroot}%{_datadir}/applications/   \
       %{SOURCE1}


%files
%doc source/aREADME.txt source/release-notes.html

%{_javadir}/imagej.jar

%{_datadir}/imagej/
%{_datadir}/applications/imagej.desktop
%{_datadir}/pixmaps/imagej.png

%{_bindir}/imagej


%changelog
