%define lname imath
%define libsover 29
%define libimath lib%lname%libsover

%def_with python

Name: %lname
Version: 3.1.12
Release: alt1.1

Summary: Imath is library of 2D and 3D vector, matrix, and math operations for graphics
License: BSD-3-Clause
Group: System/Libraries
URL: https://github.com/AcademySoftwareFoundation/Imath

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-build-python3
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: python3-module-setuptools
%if_with python
BuildRequires: boost-python3-devel
BuildRequires: python3-module-numpy
%endif

%description
Imath is a basic, light-weight, and efficient C++ representation of
2D and 3D vectors and matrices and other simple but useful mathematical
objects, functions, and data types common in computer graphics applications,
including the "half" 16-bit floating-point type.

Imath also includes optional python bindings for all types and functions,
including optimized implementations of vector and matrix arrays.

%package devel
Summary: Imath is library of 2D and 3D vector, matrix, and math operations for graphics
Group: Development/C++
Provides: libimath29-devel = %EVR
Obsoletes: libimath29-devel < %EVR

%description devel
Imath is a basic, light-weight, and efficient C++ representation of
2D and 3D vectors and matrices and other simple but useful mathematical
objects, functions, and data types common in computer graphics applications,
including the "half" 16-bit floating-point type.

Imath also includes optional python bindings for all types and functions,
including optimized implementations of vector and matrix arrays.

%package -n python3-module-%lname
Summary: Imath python3 module
Group: Development/Python3

%description -n python3-module-%lname
Imath also includes optional python bindings for all types and functions,
including optimized implementations of vector and matrix arrays.

%package -n python3-module-%lname-devel
Summary: Imath python3 module
Group: Development/Python3

%description -n python3-module-%lname-devel
Imath also includes optional python bindings for all types and functions,
including optimized implementations of vector and matrix arrays

%package -n %libimath
Summary: %lname library
Group: System/Libraries
%description -n %libimath
%lname library.


%prep
%setup

%build
%cmake \
    -DPYTHON:BOOL=%{?_with_python:ON}%{?!_with_python:OFF} \
    -DDOCS=ON

%cmake_build

%install
%cmake_install

# relax depends on binary files
for f in %buildroot/%_libdir/cmake/Imath/*Targets.cmake ; do
    sed -i '/message.*FATAL_ERROR.*target.* references the file/s|FATAL_ERROR|WARNING|' $f
done

%files -n %libimath
%_libdir/libImath*.so.%libsover
%_libdir/libImath*.so.%libsover.*

%files devel
%_includedir/Imath/Imath*.h
%_includedir/Imath/half*.h
%_pkgconfigdir/Imath.pc
%_libdir/cmake/Imath/*.cmake
%_libdir/libImath*.so

%if_with python
%files -n python3-module-%lname
%python3_sitelibdir/*.so
%_libdir/libPy*.so.*

%files -n python3-module-%lname-devel
%_libdir/libPy*.so
%_pkgconfigdir/PyImath.pc
%_includedir/Imath/Py*.h
%endif

%changelog
