%define major 1.4

# pack shared libinkscape library
%def_with shared

%def_without gnome_vfs
%def_without dbus
%def_disable check

# some reasons to prefer GraphicsMagick over ImageMagick: http://www.graphicsmagick.org/
%def_with graphicsmagick

Name: inkscape
Version: %major
Release: alt2

Summary: A Vector Drawing Application

License: GPLv2
Group: Graphics
Url: http://inkscape.org

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://media.inkscape.org/dl/resources/file/inkscape-%version.tar.xz
Source: %name-%version.tar

Source1: inkview.desktop

Patch1: inkscape-1.4-fedora-poppler-25.02.0-01.patch
Patch2: inkscape-1.4-fedora-poppler-25.02.0-02.patch
Patch3: inkscape-1.4-fedora-poppler-25.02.0-03.patch
Patch4: inkscape-1.4-fedora-poppler-25.02.0-04.patch
Patch5: inkscape-1.4-fedora-poppler-25.02.0-05.patch
Patch6: inkscape-1.4-fedora-poppler-25.02.0-06.patch

# a program package can't have any provides
AutoProv:no

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-cmake

# for c9f2 / p9
# fix /usr/bin/ld.default: cannot find -lstdc++fs
%if "%__gcc_version_major" == "8"
BuildRequires: libstdc++8-devel-static
%endif

BuildRequires: cmake gcc-c++ intltool
BuildRequires: boost-devel-headers boost-filesystem-devel boost-asio-devel
BuildRequires: libgc-devel libgsl-devel libpopt-devel libxslt-devel zlib-devel libsoup-devel libaspell-devel libdbus-devel libgspell-devel libreadline-devel

BuildRequires: lib2geom-devel >= 1:1.4

# Checking for modules 'gtkmm-3.0>=3.24;gdkmm-3.0>=3.24;gtk+-3.0>=3.24;gdk-3.0>=3.24'
BuildRequires: pkgconfig(gtkmm-3.0) >= 3.24
BuildRequires: pkgconfig(gdkmm-3.0) >= 3.24
BuildRequires: pkgconfig(gtk+-3.0) >= 3.24
BuildRequires: pkgconfig(gdk-3.0) >= 3.24

%{?_with_gnome_vfs:BuildRequires: gnome-vfs-devel}
%{?_with_dbus: BuildRequires: libdbus-devel}
BuildRequires: libwpg-devel librevenge-devel libcdr-devel libvisio-devel
BuildRequires: libpng-devel libexif-devel libjpeg-devel
BuildRequires: libpoppler-devel libpoppler-glib-devel
BuildRequires: libpotrace-devel liblcms2-devel
%if_with graphicsmagick
BuildRequires: libGraphicsMagick-c++-devel
%else
BuildRequires: libImageMagick-devel
%endif
BuildRequires: libgomp-devel
BuildRequires: libepoxy-devel
BuildRequires: libdouble-conversion-devel
BuildRequires: perl-podlators
BuildRequires: libgtksourceview4-devel

%add_python3_lib_path %_datadir/%name/extensions

Requires: icc-profiles
Requires: python3-module-appdirs

# For extensions
# https://bugzilla.altlinux.org/21626
Requires: wmf-utils
# Recommends: skencil pstoedit

# mike: work around https://bugzilla.altlinux.org/24586
#Requires: gnome-icon-theme

# to support svg in libgdk-pixbuf
Requires: librsvg

Requires: %name-data = %EVR
Requires: inkscape-tutorial
Requires: lib%name = %EVR

# due $ORIGIN using
Requires: /proc

%description
Inkscape is a SVG based generic vector-drawing program for Linux/Unix
and Windows.  It uses an advanced imaging engine with anti-aliased
display, alpha transparency, and vector fonts.

%description -l ru_RU.UTF-8
Inkscape -- это программа векторного рисования общего назначения,
использующая формат SVG, работающая на платформах Linux/Unix/Windows
и имеющая мощный движок для отображения графики со сглаживанием,
альфа-каналом и векторными шрифтами.

%package viewer
Summary: Viewer for Inkscape files
Group: Graphics
Requires: lib%name = %EVR
# TODO: uses
# /usr/share/inkscape/ui/menus.xml
# /usr/share/inkscape/ui/style.css
# /usr/share/inkscape/fonts
#Requires: %name-data = %EVR

%description viewer
inkview is standalone viewer for Inkscape files (SVG).

%package data
Summary: Inkscape common data files
Group: Graphics
BuildArch: noarch
Requires: icon-theme-hicolor

# a data package can't have any provides
AutoProv:no

%description data
Inkview tutorial.

%package -n lib%name
Summary: Inkscape shared library
Group: System/Libraries

%description -n lib%name
Inkscape shared library.


%package tutorial
Summary: Inkscape tutorial
Group: Graphics
BuildArch: noarch

%description tutorial
Inkview tutorial.

%package checkinstall
Summary: Checkinstall for %name
Group: Development/Other
BuildArch: noarch
#Requires(pre): %name = %EVR
Conflicts: python3(setuptools)

%description checkinstall
Run checkinstall tests for %name.

%prep
%setup
%autopatch -p1

%ifarch %e2k
# missing typeinfo fix
cat >> src/inkscape-version.cpp.in << "EOF"
#include <typeinfo>
namespace Geom { struct Curve { };
	__attribute__((visibility("hidden")))
	auto Curve_typeinfo_ptr = &typeid(Curve); }
EOF
# LCC cannot work with expressions inside openmp pragmas
sed -i -E "/^[[:space:]]*#pragma omp .* (num_threads|if)\(/{s/#/for(long &/;\
s/(#.*num_threads\()([^()]*(\(\))*)\)/_xxxn=\\2,\\1_xxxn)/;\
s/(#.*if\()([^()]*)\)/_xxxi=\\2,\\1_xxxi)/;\
s/#/_xxxc=1;_xxxc;_xxxc=0)\n&/}" \
	src/display/{cairo-templates.h,nr-filter-morphology.cpp}
sed -i 's/~*FontFactory();/public:&/' src/libnrtype/font-factory.h
sed -i 's/~*PatternManager();/public:&private:/' src/pattern-manager.h
sed -i 's/~*FontDiscovery();/public:&private:/' src/util/font-discovery.h
sed -i 's/]: {std::tuple/]: {/;s/{C_("Grid"/std::tuple&/' \
	src/ui/dialog/document-properties.cpp
sed -i -E 's/if \((static.*;)(.*)$/\1 if(\2/' src/ui/widget/page-properties.cpp
%endif
rm -rv src/3rdparty/2geom/

%build
%cmake_insource \
%if_with shared
    -DBUILD_SHARED_LIBS=ON \
    -DCMAKE_SKIP_RPATH=OFF \
    -DCMAKE_SKIP_INSTALL_RPATH=OFF \
    -DWITH_GNU_READLINE=ON \
    -DWITH_INTERNAL_2GEOM=OFF \
%else
    -DBUILD_SHARED_LIBS=OFF \
%endif
%if_with graphicsmagick
    -DWITH_IMAGE_MAGICK=OFF \
    -DWITH_GRAPHICS_MAGICK=ON \
%else
    -DWITH_IMAGE_MAGICK=ON \
    -DWITH_GRAPHICS_MAGICK=OFF \
%endif
    %nil
# FIXME: ppc64le (make -j132):
# No rule to make target 'po/bn.gmo', needed by 'share/templates/default_templates.timestamp
%make_build || %make_build -j2

%install
%makeinstall_std

# remove unneeded man
rm -rv %buildroot%_mandir/??/
rm -rv %buildroot%_mandir/??_??/

subst "s|/usr/bin/env python$|%__python3|" %buildroot%_datadir/%name/extensions/*.py
subst "s|/usr/bin/env python$|%__python3|" %buildroot%_datadir/%name/extensions/*/*.py
subst "s|/usr/bin/env python$|%__python3|" %buildroot%_datadir/%name/extensions/*/*/*.py
subst "s|/usr/bin/env python$|%__python3|" %buildroot%_datadir/%name/extensions/*/*/*/*.py
subst "s|/usr/bin/env python$|%__python3|" %buildroot%_datadir/%name/extensions/*/*/*/*/*.py

# remove tests
rm -rv %buildroot%_datadir/%name/extensions/inkex/tester/
rm -v %buildroot%_datadir/%name/extensions/other/extension-xaml/inkxaml/tester.py

%find_lang %name

install -m644 %SOURCE1 %buildroot%_desktopdir/inkview.desktop

%check
$(INKSCAPE) -z -f $< --export-eps=$@
$(INKSCAPE) -z -f $< --export-png=$@
true

%files -f %name.lang
%doc AUTHORS CONTRIBUTING.md NEWS.md COPYING README.md doc
%_bindir/inkscape
%_desktopdir/org.inkscape.Inkscape.desktop
%_man1dir/inkscape*
#_mandir/??/man1/inkscape.??.1.*
%_datadir/metainfo/org.inkscape.Inkscape.appdata.xml
/usr/share/bash-completion/completions/inkscape

%files data
%_datadir/%name/
%exclude %_datadir/inkscape/tutorials/
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/*/apps/*.svg

%files viewer
%_bindir/inkview
%_man1dir/inkview*
%_desktopdir/inkview.desktop

%if_with shared
%files -n lib%name
%dir %_libdir/inkscape/
%_libdir/inkscape/libinkscape_base.so
%_libdir/inkscape/libinkscape_base.so.*
%endif

%files tutorial
%dir %_datadir/%name/
%_datadir/inkscape/tutorials/

%files checkinstall

%changelog
